/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.attachment;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.attachment.AttachmentMetadata;
import com.atlassian.bitbucket.attachment.AttachmentService;
import com.atlassian.bitbucket.attachment.AttachmentSupplier;
import com.atlassian.bitbucket.dmz.rest.v2.attachment.RestAttachmentMetadata;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.attachment.PluginDownloadHeaderHelper;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpRange;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/attachments")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Singleton
@Tag(name="Repository")
public class AttachmentResource {
    private static final String ATTACHMENT_ID = "attachmentId";
    private static final String ATTACHMENT_ID_PATH = "{attachmentId}";
    private static final String ATTACHMENT_METADATA_PATH = "{attachmentId}/metadata";
    private static final int BUFFER_SIZE = 8192;
    private final AttachmentService attachmentService;
    private final PluginDownloadHeaderHelper downloadHeaderHelper;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;

    @Inject
    public AttachmentResource(AttachmentService attachmentService, PluginDownloadHeaderHelper downloadHeaderHelper, I18nService i18nService, NavBuilder navBuilder) {
        this.attachmentService = attachmentService;
        this.downloadHeaderHelper = downloadHeaderHelper;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
    }

    @Operation(description="Delete an attachment.\n\nThe user must be authenticated and have <strong>REPO_ADMIN</strong> permission for the specified repository.", summary="Delete an attachment")
    @Parameters(value={@Parameter(description="the attachment ID", in=ParameterIn.PATH, name="attachmentId")})
    @ResponseDocs(value={@ResponseDoc(documentation="", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the attachment", restError=true, responseCode=401), @ResponseDoc(documentation="The attachment does not exist", restError=true, responseCode=404)})
    @DELETE
    @Path(value="{attachmentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteAttachment(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="attachmentId") long attachmentId) {
        if (!this.attachmentService.delete(repositoryResolver.getRepository(), attachmentId)) {
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.rest.attachment.nosuchattachment", new Object[]{Long.toString(attachmentId)}), Long.toString(attachmentId));
        }
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Delete attachment metadata.\n\nThe user must be authenticated and have <strong>REPO_ADMIN</strong> permission for the specified repository.", summary="Delete attachment metadata")
    @Parameters(value={@Parameter(description="the attachment ID", in=ParameterIn.PATH, name="attachmentId")})
    @ResponseDocs(value={@ResponseDoc(documentation="", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete theattachment metadata", restError=true, responseCode=401), @ResponseDoc(documentation="The attachment or the attachment metadata does not exist", restError=true, responseCode=404)})
    @DELETE
    @Path(value="{attachmentId}/metadata")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteAttachmentMetadata(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="attachmentId") long attachmentId) {
        if (!this.attachmentService.deleteMetadata(repositoryResolver.getRepository(), attachmentId)) {
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.rest.attachment.metadata.nosuchattachmentmetadata", new Object[]{Long.toString(attachmentId)}), Long.toString(attachmentId));
        }
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieve the attachment.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository that is associated to the attachment.\n\nRange requests (see IETF RFC7233) are supported. However only a single range issupported. If multiple ranges are passed the ranges will be ignored and the entire content will be returned in the response.", summary="Get an attachment")
    @Parameters(value={@Parameter(description="the attachment ID", in=ParameterIn.PATH, name="attachmentId")})
    @ResponseDocs(value={@ResponseDoc(documentation="the attachment", responseCode=200), @ResponseDoc(documentation="the requested range of bytes from the attachment", responseCode=206), @ResponseDoc(documentation="the user is currently not authenticated", restError=true, responseCode=401), @ResponseDoc(documentation="The attachment does not exist", restError=true, responseCode=404)})
    @GET
    @Path(value="{attachmentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAttachment(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="attachmentId") long attachmentId, @HeaderParam(value="Range") String rangeHeader, @HeaderParam(value="User-Agent") String userAgent) {
        HttpRange httpRange;
        try {
            List httpRanges = HttpRange.parseRanges((String)rangeHeader);
            httpRange = httpRanges.size() == 1 ? (HttpRange)httpRanges.get(0) : null;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.attachment.invalidrange", new Object[]{e.getMessage()}));
        }
        AttachmentSupplier supplier = this.attachmentService.read(repositoryResolver.getRepository(), attachmentId);
        Response.ResponseBuilder builder = httpRange == null ? ResponseFactory.ok() : ResponseFactory.status((int)206);
        return builder.entity((headers, outputStream) -> {
            try (BufferedInputStream inputStream = new BufferedInputStream(supplier.open());){
                String attachmentPath = supplier.getName();
                String fileContentType = (String)MoreObjects.firstNonNull((Object)ContentDetectionUtils.detectContentType((InputStream)inputStream, (String)attachmentPath), (Object)"application/octet-stream");
                this.downloadHeaderHelper.setDownloadHeaders((MultivaluedMap<String, Object>)headers, attachmentPath, fileContentType, userAgent);
                long attachementSize = supplier.getSize();
                long start = 0L;
                long length = attachementSize;
                if (httpRange != null) {
                    start = httpRange.getRangeStart(attachementSize);
                    long end = httpRange.getRangeEnd(attachementSize);
                    length = end - start + 1L;
                    headers.add((Object)"Content-Range", (Object)("bytes " + start + "-" + end + "/" + attachementSize));
                }
                headers.add((Object)"Accept-Ranges", (Object)"bytes");
                headers.add((Object)"Content-Length", (Object)Long.toString(length));
                byte[] buffer = new byte[8192];
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream, (long)start, (long)length, (byte[])buffer);
                outputStream.flush();
            }
        }).cacheControl(CachePolicies.cacheForAMonth()).build();
    }

    @Operation(description="Retrieve the attachment metadata.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository that is associated to the attachment that has the attachment metadata.", summary="Get attachment metadata")
    @Parameters(value={@Parameter(description="the attachment ID", in=ParameterIn.PATH, name="attachmentId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The attachment metadata", representation=RestAttachmentMetadata.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the attachment metadata", restError=true, responseCode=401), @ResponseDoc(documentation="The attachment or the attachment metadata does not exist", restError=true, responseCode=404)})
    @GET
    @Path(value="{attachmentId}/metadata")
    @Produces(value={"application/json;charset=UTF-8"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAttachmentMetadata(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="attachmentId") long attachmentId) {
        AttachmentMetadata attachmentMetadata = this.attachmentService.getMetadata(repositoryResolver.getRepository(), attachmentId);
        String url = this.navBuilder.repo(repositoryResolver.getRepository()).attachment(attachmentId).metadata().buildRelNoContext();
        return ResponseFactory.ok().entity((Object)new RestAttachmentMetadata(attachmentMetadata, url)).build();
    }

    @Operation(description="Save attachment metadata.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository that is associated to the attachment that has the attachment metadata.", summary="Save attachment metadata")
    @Parameters(value={@Parameter(description="the attachment ID", in=ParameterIn.PATH, name="attachmentId")})
    @RequestBody(description="The attachment metadata can be any valid JSON content", content={@Content(schema=@Schema(description="any valid JSON content"))})
    @ResponseDocs(value={@ResponseDoc(documentation="The attachment metadata", responseCode=200), @ResponseDoc(documentation="The supplied content is not valid JSON", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to save theattachment metadata", restError=true, responseCode=401), @ResponseDoc(documentation="The repository or the attachment does not exist", restError=true, responseCode=404)})
    @Consumes(value={"application/json"})
    @Path(value="{attachmentId}/metadata")
    @Produces(value={"application/json;charset=UTF-8"})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response saveAttachmentMetadata(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="attachmentId") long attachmentId, Map<String, Object> requestMetadata) {
        AttachmentMetadata attachmentMetadata = this.attachmentService.saveMetadata(repositoryResolver.getRepository(), attachmentId, requestMetadata);
        return ResponseFactory.ok().entity((Object)attachmentMetadata.getMetadata()).build();
    }
}

