/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.attachment;

import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.http.mime.ContentDispositionHeaderGuesser;
import com.atlassian.stash.internal.rest.attachment.PluginDownloadHeaderHelper;
import jakarta.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;

public class PluginDefaultDownloadHeaderHelper
implements PluginDownloadHeaderHelper {
    private final ContentDispositionHeaderGuesser contentDispositionGuesser;

    public PluginDefaultDownloadHeaderHelper(ContentDispositionHeaderGuesser contentDispositionGuesser) {
        this.contentDispositionGuesser = contentDispositionGuesser;
    }

    @Override
    public void setDownloadHeaders(MultivaluedMap<String, Object> headers, String path, String fileContentType, String userAgent) {
        String contentDisposition = this.contentDispositionGuesser.guessContentDispositionHeader(path, fileContentType, userAgent);
        Object contentType = this.contentDispositionGuesser.guessMIME(path, fileContentType, userAgent);
        if (StringUtils.startsWith((CharSequence)contentType, (CharSequence)"text/")) {
            contentType = (String)contentType + ";charset=UTF-8";
        }
        if ("attachment".equals(contentDisposition)) {
            headers.add((Object)"X-Download-Options", (Object)"noopen");
        }
        String filename = path.contains("/") ? StringUtils.substringAfterLast((String)path, (String)"/") : path;
        headers.add((Object)"Content-Disposition", (Object)ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.fromString((String)contentDisposition), (String)filename));
        headers.add((Object)"Content-Type", contentType);
    }
}

