/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.autodecline;

import com.atlassian.bitbucket.dmz.autodecline.AutoDeclineSettings;
import com.atlassian.bitbucket.dmz.autodecline.DmzAutoDeclineSettingsService;
import com.atlassian.bitbucket.dmz.rest.v2.autodecline.RestAutoDeclineSettings;
import com.atlassian.bitbucket.dmz.rest.v2.autodecline.RestAutoDeclineSettingsRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.core.Response;

public abstract class AbstractAutoDeclineSettingsResource {
    private final DmzAutoDeclineSettingsService autoDeclineSettingsService;
    private final Validator validator;

    public AbstractAutoDeclineSettingsResource(DmzAutoDeclineSettingsService autoDeclineSettingsService, Validator validator) {
        this.autoDeclineSettingsService = autoDeclineSettingsService;
        this.validator = validator;
    }

    protected Response deleteSettings(@BeanParam ScopeResolver scopeResolver) {
        this.autoDeclineSettingsService.delete(scopeResolver.getScope());
        return ResponseFactory.noContent().build();
    }

    protected Response getSettings(@BeanParam ScopeResolver scopeResolver) {
        return ResponseFactory.ok((Object)new RestAutoDeclineSettings(this.autoDeclineSettingsService.getOrDefault(scopeResolver.getScope()))).build();
    }

    protected Response setSettings(@BeanParam ScopeResolver scopeResolver, RestAutoDeclineSettingsRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        try {
            AutoDeclineSettings newSettings = this.autoDeclineSettingsService.createOrUpdate(scopeResolver.getScope(), request.getInactivityWeeks(), request.getEnabled());
            return ResponseFactory.ok((Object)new RestAutoDeclineSettings(newSettings)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)e.getLocalizedMessage()).build();
        }
    }
}

