/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.autodecline;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.autodecline.DmzAutoDeclineSettingsService;
import com.atlassian.bitbucket.dmz.rest.v2.autodecline.RestAutoDeclineSettings;
import com.atlassian.bitbucket.dmz.rest.v2.autodecline.RestAutoDeclineSettingsRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.autodecline.AbstractAutoDeclineSettingsResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/settings/auto-decline")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class AutoDeclineSettingsRepositoryResource
extends AbstractAutoDeclineSettingsResource {
    @Inject
    public AutoDeclineSettingsRepositoryResource(DmzAutoDeclineSettingsService autoDeclineSettingsService, Validator validator) {
        super(autoDeclineSettingsService, validator);
    }

    @Operation(description="Delete auto decline settings for the supplied repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for this repository to call the resource.", summary="Delete auto decline settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The auto decline settings have been deleted successfully.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the auto decline settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteAutoDeclineSettings(@BeanParam ScopeResolver scopeResolver) {
        return this.deleteSettings(scopeResolver);
    }

    @Operation(description="Retrieves the auto decline settings for the supplied repository. Project settings will be returned if no explicit settings have been set for the repository. In the case that there are no project settings, the default settings will be returned.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for this repository to call the resource.", summary="Get auto decline settings")
    @ResponseDocs(value={@ResponseDoc(documentation="The auto decline settings", representation=RestAutoDeclineSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the auto decline settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAutoDeclineSettings(@BeanParam ScopeResolver scopeResolver) {
        return this.getSettings(scopeResolver);
    }

    @Operation(description="Creates or updates the auto decline settings for the supplied repository.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for this repository to call the resource", summary="Create auto decline settings")
    @RequestBody(description="The settings to create or update", content={@Content(schema=@Schema(implementation=RestAutoDeclineSettingsRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The auto decline settings", representation=RestAutoDeclineSettings.class, responseCode=200), @ResponseDoc(documentation="inactivityWeeks was not one of 1, 2, 4, 8, or, 12, or the enabled parameter was not included in the request.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create or update the auto decline settings.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist.", restError=true, responseCode=404)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setAutoDeclineSettings(@BeanParam ScopeResolver scopeResolver, RestAutoDeclineSettingsRequest request) {
        return this.setSettings(scopeResolver, request);
    }
}

