/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.build;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestBuildCapabilities;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;

@UnrestrictedAccess
@Path(value="build/capabilities")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Capabilities")
public class BuildCapabilitiesResource {
    private static final String CAPABILITY_DISABLED = "plugin.builds.extended.capability.disabled";
    private final ApplicationPropertiesService propertiesService;

    @Inject
    public BuildCapabilitiesResource(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @Operation(description="Returns the build capabilities of this instance", summary="Get build capabilities")
    @ResponseDocs(value={@ResponseDoc(documentation="capabilities", representation=RestBuildCapabilities.class, responseCode=200)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCapabilities() {
        if (this.propertiesService.getPluginProperty(CAPABILITY_DISABLED, false)) {
            return ResponseFactory.notFound().build();
        }
        return ResponseFactory.ok((Object)new RestBuildCapabilities(), (CacheControl)CachePolicies.publicCacheForAnHour()).build();
    }
}

