/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.build;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.build.status.BuildServer;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.bitbucket.dmz.build.server.DmzBuildServerService;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.SimpleTestResults;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestBuildStatus;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestBuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestTestResults;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/builds")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Builds and Deployments")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug."), @PathParamDoc(name="commitId", documentation="The commit.")})
public class RepositoryBuildStatusResource {
    private final AvatarEnricher avatarEnricher;
    private final DmzBuildServerService buildServerService;
    private final DmzBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final Validator validator;

    @Inject
    public RepositoryBuildStatusResource(AvatarEnricher avatarEnricher, DmzBuildServerService buildServerService, DmzBuildStatusService buildStatusService, I18nService i18nService, Validator validator) {
        this.avatarEnricher = avatarEnricher;
        this.buildServerService = buildServerService;
        this.buildStatusService = buildStatusService;
        this.i18nService = i18nService;
        this.validator = validator;
    }

    @Operation(description="Store a build status.\n\n\nThe authenticated user must have **REPO_READ** permission for the repository that this build status is for. The request can also be made with anonymous 2-legged OAuth.", summary="Store a build status")
    @RequestBody(description="The contents of the build status request are:\nThese fields are **required**:\n\n\n- **key**: The string referring to this branch plan/job\n- **state**: The build status state, one of: \"SUCCESSFUL\", \"FAILED\", \"INPROGRESS\", \"CANCELLED\", \"UNKNOWN\"\n- **url**: URL referring to the build result page in the CI tool.\n\n\nThese fields are optional:\n\n\n- **buildNumber** (optional): A unique identifier for this particular run of a plan<\n- **dateAdded** (optional): milliseconds since epoch. If not provided current date is used.\n- **description** (optional): Describes the build result\n- **duration** (optional): Duration of a completed build in milliseconds.\n- **name** (optional): A short string that describes the build plan\n- **parent** (optional): The identifier for the plan or job that ran the branch plan that produced this build status. This field is used for required builds merge checks to function\n- **ref** (optional): The fully qualified git reference e.g. refs/heads/master.\n- **testResults** (optional): A summary of the passed, failed and skipped tests.\n", content={@Content(schema=@Schema(implementation=RestBuildStatusSetRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The build status was posted", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to push a build status to this repository", restError=true, responseCode=401), @ResponseDoc(documentation="The build status was not added as the request was invalid. This could be because of a number of things:\n\n\n- an invalid commit hash was provided\n- build key was blank or longer than 255 characters\n- invalid branch was provided\n- invalid state was provided\n- build status url was blank or longer than 450 characters\n\nThe specifics will be included in the error message.", restError=true, responseCode=400), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @EscalateAnonymous2LO(value={Permission.PROJECT_VIEW, Permission.REPO_READ})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response add(@BeanParam RepositoryResolver repositoryResolver, RestBuildStatusSetRequest request, @PathParam(value="commitId") String commitId, @Context HttpServletRequest servletRequest) {
        if (!ShaUtils.isHash((String)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.build.status.commit.invalid", new Object[0]));
        }
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        BuildServer buildServer = this.buildServerService.getBuildServer(servletRequest, (Map)request).orElse(null);
        RepositoryBuildStatusSetRequest.Builder builder = new RepositoryBuildStatusSetRequest.Builder(repositoryResolver.getRepository(), commitId, request.getKey()).buildNumber(request.getBuildNumber()).description(request.getDescription()).duration(request.getDuration()).lastUpdated(request.getLastUpdated() == null ? null : new Date(request.getLastUpdated())).name(request.getName()).parent(request.getParent()).ref(request.getRef()).state(request.getState()).url(request.getUrl());
        RestTestResults restTestResults = request.getTestResults();
        if (restTestResults != null) {
            TestResults testResults = new SimpleTestResults.Builder().failed(restTestResults.getFailed()).skipped(restTestResults.getSkipped()).successful(restTestResults.getSuccessful()).build();
            builder.testResults(testResults);
        }
        this.buildStatusService.setInternal(builder.build(), buildServer);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Delete a specific build status. \n\nThe authenticated user must have **REPO_ADMIN** permission for the provided repository.", summary="Delete a specific build status")
    @Parameter(description="the key of the build status", in=ParameterIn.QUERY, name="key", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The build status associated with the provided commit and key has been deleted", responseCode=204), @ResponseDoc(documentation="The request has failed validation", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions this repository", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@PathParam(value="commitId") String commitId, @QueryParam(value="key") String key, @BeanParam RepositoryResolver repositoryResolver) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.build.status.key.invalid", new Object[0]));
        }
        if (!ShaUtils.isHash((String)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.build.status.commit.invalid", new Object[0]));
        }
        this.buildStatusService.remove(repositoryResolver.getRepository(), commitId, key);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Get a specific build status.\n\n\nThe authenticated user must have **REPO_READ** permission for the provided repository.The request can also be made with anonymous 2-legged OAuth.<br>Since 7.14", summary="Get a specific build status")
    @Parameter(description="the key of the build status", in=ParameterIn.QUERY, name="key", required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="The build status associated with the provided commit and key", representation=RestBuildStatus.class, responseCode=200), @ResponseDoc(documentation="The request has failed validation", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions this repository", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository, commit or build status does not exist", restError=true, responseCode=404)})
    @EscalateAnonymous2LO(value={Permission.PROJECT_VIEW, Permission.REPO_READ})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@PathParam(value="commitId") String commitId, @QueryParam(value="key") String key, @BeanParam RepositoryResolver repositoryResolver, @Context ContainerRequestContext request) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.build.status.key.invalid", new Object[0]));
        }
        if (!ShaUtils.isHash((String)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.build.status.commit.invalid", new Object[0]));
        }
        return this.buildStatusService.get(repositoryResolver.getRepository(), commitId, key).map(buildStatus -> {
            RestCommit restCommit = buildStatus.getCommit().map(commit -> (RestCommit)RestCommit.createTransformer((ContainerRequestContext)request, (AvatarEnricher)this.avatarEnricher, (I18nService)this.i18nService).apply(commit)).orElse(null);
            return new RestBuildStatus(buildStatus, restCommit);
        }).map(ResponseFactory::ok).orElseGet(ResponseFactory::notFound).build();
    }
}

