/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.cluster;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mirror.MirrorAvailable;
import com.atlassian.bitbucket.dmz.rest.v2.cluster.RestClusterInformation;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@MirrorAvailable
@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/cluster")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class ClusterResource {
    private final ClusterService clusterService;
    private final PermissionValidationService validationService;

    @Inject
    public ClusterResource(ClusterService clusterService, PermissionValidationService validationService) {
        this.clusterService = clusterService;
        this.validationService = validationService;
    }

    @Operation(description="Gets information about the nodes that currently make up the stash cluster.\n\nThe authenticated user must have the <strong>SYS_ADMIN</strong> permission to call this resource.", summary="Get cluster node information")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing information about the cluster", representation=RestClusterInformation.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the cluster information.", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getInformation() {
        this.validationService.validateForGlobal(Permission.SYS_ADMIN);
        return ResponseFactory.ok((Object)new RestClusterInformation(this.clusterService.getInformation())).build();
    }
}

