/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.content.RestChange;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/changes")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CommitChangeResource {
    private final CommitService commitService;
    private final NavBuilder navBuilder;

    @Inject
    public CommitChangeResource(CommitService commitService, NavBuilder navBuilder) {
        this.commitService = commitService;
        this.navBuilder = navBuilder;
    }

    @Operation(description="Retrieve a page of changes made in a specified commit. \n\n <strong>Note:</strong> The implementation will apply a hard cap (<code>page.max.changes</code>) and it is not possible to request subsequent content when that cap is exceeded. \n\n The authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get changes in commit")
    @Parameters(value={@Parameter(description="The commit to retrieve changes for", in=ParameterIn.PATH, name="commitId"), @Parameter(description="The commit to which <code>until</code> should be compared to produce a page of changes. If not specified the commit's first parent is assumed (if one exists)", in=ParameterIn.QUERY, name="since"), @Parameter(description="<code>true</code> to apply comment counts in the changes (the default); otherwise, <code>false</code> to stream changes without comment counts", in=ParameterIn.QUERY, name="withComments")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of changes", representation=RestChange.class, paged=true, responseCode=200), @ResponseDoc(documentation="The until parameter was not supplied", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository or the since or until parameters supplied does not exist.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getChanges(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="commitId") String commitId, final @QueryParam(value="since") String sinceId, final @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, final @BeanParam PageRequestResolver pageRequestResolver) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                ChangesRequest request = new ChangesRequest.Builder(repositoryResolver.getRepository(), commitId).sinceId(sinceId).withComments(withComments).build();
                NavBuilder.Commit commitNav = CommitChangeResource.this.navBuilder.repo(repositoryResolver.getRepository()).commit(commitId);
                CommitChangeResource.this.commitService.streamChanges(request, (ChangeCallback)new JsonChangeCallback(writer, pageRequestResolver.getPageRequest(), commitNav));
            }
        }, (CacheControl)(withComments ? CachePolicies.noCache() : CachePolicies.getCacheControlForRange((String)commitId, (String)sinceId))).build();
    }
}

