/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.comment.AddCommentReplyRequest;
import com.atlassian.bitbucket.comment.AddCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.AddLineCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.CommentUpdateRequest;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.dmz.comment.AddMultilineCommentRequest;
import com.atlassian.bitbucket.dmz.comment.DmzCommentService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.resolver.CommentResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.util.CommentUtils;
import com.atlassian.stash.internal.rest.util.MultilineCommentValidator;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug"), @PathParamDoc(name="commitId", documentation="The <i>full ID</i> of the commit within the repository")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CommitCommentResource {
    private final DmzCommentService commentService;
    private final CommitService commitService;
    private final I18nService i18nService;
    private final MultilineCommentValidator multilineCommentValidator;

    @Inject
    public CommitCommentResource(I18nService i18nService, DmzCommentService commentService, CommitService commitService, MultilineCommentValidator multilineCommentValidator) {
        this.commentService = commentService;
        this.commitService = commitService;
        this.i18nService = i18nService;
        this.multilineCommentValidator = multilineCommentValidator;
    }

    @Operation(description="Add a new comment.\n\nComments can be added in a few places by setting different attributes:\n\nGeneral commit comment:\n\n```{\n      \"text\": \"An insightful general comment on a commit.\"\n}\n\n</pre>\nReply to a comment:\n<pre>{\n      \"text\": \"A measured reply.\",\n      \"parent\": {\n          \"id\": 1\n      }\n}\n</pre>\nGeneral file comment:\n<pre>{\n      \"text\": \"An insightful general comment on a file.\",\n      \"anchor\": {\n          \"diffType\": \"COMMIT\",\n          \"fromHash\": \"6df3858eeb9a53a911cd17e66a9174d44ffb02cd\",\n          \"path\": \"path/to/file\",\n          \"srcPath\": \"path/to/file\",\n          \"toHash\": \"04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\"\n      }\n}\n</pre>\nFile line comment:\n<pre>{\n      \"text\": \"A pithy comment on a particular line within a file.\",\n      \"anchor\": {\n          \"diffType\": \"COMMIT\",\n          \"line\": 1,\n          \"lineType\": \"CONTEXT\",\n          \"fileType\": \"FROM\",\n          \"fromHash\": \"6df3858eeb9a53a911cd17e66a9174d44ffb02cd\",\n          \"path\": \"path/to/file\",\n          \"srcPath\": \"path/to/file\",\n          \"toHash\": \"04c7c5c931b9418ca7b66f51fe934d0bd9b2ba4b\"\n      }\n}\n```\n\nNote: general file comments are an experimental feature and may change in the near future!\n\nFor file and line comments, 'path' refers to the path of the file to which the comment should be applied and 'srcPath' refers to the path the that file used to have (only required for copies and moves). Also, fromHash and toHash refer to the sinceId / untilId (respectively) used to produce the diff on which the comment was added. fromHash will be resolved automatically as first parent if not specified. Note that this behaviour differs from `/pull-requests/comments`\n\nFinally diffType refers to the type of diff the comment was added on.\n\nFor line comments, 'line' refers to the line in the diff that the comment should apply to. 'lineType' refers to the type of diff hunk, which can be:- 'ADDED' - for an added line;</li>- 'REMOVED' - for a removed line; or</li>- 'CONTEXT' - for a line that was unmodified but is in the vicinity of the diff.</li>'fileType' refers to the file of the diff to which the anchor should be attached - which is of relevance when displaying the diff in a side-by-side way. Currently the supported values are:- 'FROM' - the source file of the diff</li>- 'TO' - the destination file of the diff</li>If the current user is not a participant the user is added as one and updated to watch the commit.\n\nThe authenticated user must have REPO_READ permission for the repository that the commit is in to call this resource.", summary="Add a new commit comment")
    @Parameters(value={@Parameter(description="For a merge commit, a parent can be provided to specify which diff the comments should be on. For a commit range, a sinceId can be provided to specify where the comments should be anchored from.", in=ParameterIn.QUERY, name="since")})
    @RequestBody(description="the comment", content={@Content(schema=@Schema(implementation=RestComment.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created comment.", representation=RestComment.class, responseCode=201), @ResponseDoc(documentation="The comment was not created due to a validation error.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the commit, create a comment or watch the commit.", restError=true, responseCode=401), @ResponseDoc(documentation="Unable to find the supplied project, repository, commit or parent comment. The missing entity will be specified in the error details.", restError=true, responseCode=404), @ResponseDoc(documentation="Adding, deleting, or editing comments isn't supported on archived repositories.", restError=true, responseCode=409)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createComment(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="since") String sinceId, @Context UriInfo uriInfo, RestComment comment) {
        Comment created;
        String commentText = comment.getText();
        if (StringUtils.isBlank((CharSequence)commentText)) {
            String message = this.i18nService.getMessage("bitbucket.rest.comment.addrequirestext", new Object[0]);
            throw new BadRequestException(message);
        }
        if (comment.isReply()) {
            Comment parent = this.doGetComment(repositoryResolver.getRepository(), commitId, comment.getParent().getId());
            created = this.commentService.addReply(new AddCommentReplyRequest.Builder(parent.getId(), commentText).build());
        } else {
            CommitDiscussion commentable = this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repositoryResolver.getRepository(), commitId).create(true).build());
            if (comment.isAnchored()) {
                RestCommentThreadDiffAnchor anchor = comment.getAnchor();
                if (anchor.isLineComment()) {
                    this.validateLineAnchor(anchor);
                    if (anchor.isMultilineComment() || anchor.getMultilineSpan() != null) {
                        List<RestErrorMessage> errors = this.multilineCommentValidator.validateMultilineAnchor(anchor);
                        if (!errors.isEmpty()) {
                            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(errors)).build();
                        }
                        AddMultilineCommentRequest multilineCommentRequest = CommentUtils.createMultilineCommentRequest(sinceId, commitId, comment, CommentThreadDiffAnchorType.COMMIT, this.toSeverity(comment.getSeverity()), (Commentable)commentable, anchor);
                        created = this.commentService.addComment(multilineCommentRequest);
                    } else {
                        created = this.commentService.addComment(((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)((AddLineCommentRequest.Builder)new AddLineCommentRequest.Builder((Commentable)commentable, commentText, CommentThreadDiffAnchorType.COMMIT, anchor.getPath().toString()).fileType((DiffFileType)MoreObjects.firstNonNull((Object)anchor.getFileType(), (Object)DiffFileType.forSegmentType((DiffSegmentType)anchor.getLineType())))).fromHash(sinceId)).line(anchor.getLine())).lineType(anchor.getLineType())).severity(this.toSeverity(comment.getSeverity()))).srcPath((String)Optional.ofNullable(anchor.getSrcPath()).map(Object::toString).orElse(null))).toHash(commitId)).build());
                    }
                } else {
                    created = this.commentService.addComment(((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)((AddFileCommentRequest.Builder)new AddFileCommentRequest.Builder((Commentable)commentable, commentText, CommentThreadDiffAnchorType.COMMIT, anchor.getPath().toString()).fromHash(sinceId)).severity(this.toSeverity(comment.getSeverity()))).srcPath((String)Optional.ofNullable(anchor.getSrcPath()).map(Object::toString).orElse(null))).toHash(commitId)).build());
                }
            } else {
                created = this.commentService.addComment(((AddCommentRequest.Builder)new AddCommentRequest.Builder((Commentable)commentable, commentText).severity(this.toSeverity(comment.getSeverity()))).build());
            }
        }
        URI uri = uriInfo.getRequestUriBuilder().path(String.valueOf(created.getId())).build(new Object[0]);
        return ResponseFactory.created((URI)uri).entity((Object)new RestComment(created)).build();
    }

    @Operation(description="Delete a commit comment. Anyone can delete their own comment. Only users with <strong>REPO_ADMIN</strong> and above may delete comments created by other users. Comments which have replies <i>may not be deleted</i>, regardless of the user's granted permissions.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that the commit is in to call this resource.", summary="Delete a commit comment")
    @Parameters(value={@Parameter(description="the comment", in=ParameterIn.PATH, name="commentId"), @Parameter(description="The expected version of the comment. This must match the server's version of the comment or the delete will fail. To determine the current version of the comment, the comment should be fetched from the server prior to the delete. Look for the 'version' attribute in the returned JSON structure.", in=ParameterIn.QUERY, name="version")})
    @ResponseDocs(value={@ResponseDoc(documentation="The operation was successful", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the comment.", restError=true, responseCode=401), @ResponseDoc(documentation="Unable to find the supplied project, repository or commit. The missing entity will be specified in the error details.", restError=true, responseCode=404), @ResponseDoc(documentation="The comment has replies, the version supplied does not match the comment's current version or the repository is archived.", restError=true, responseCode=409)})
    @DELETE
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteComment(@BeanParam RepositoryResolver repositoryResolver, @BeanParam CommentResolver commentResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="version") @DefaultValue(value="-1") int version) {
        CommitDiscussion discussion = this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repositoryResolver.getRepository(), commitId).create(false).build());
        Comment comment = commentResolver.getComment();
        if (!comment.getThread().getCommentable().equals((Object)discussion)) {
            throw this.noSuchCommentException(comment.getId());
        }
        this.commentService.deleteComment(comment.getId(), version);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieves a commit discussion comment.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that the commit is in to call this resource.", summary="Get a commit comment")
    @Parameters(value={@Parameter(description="The ID of the comment to retrieve", in=ParameterIn.PATH, name="commentId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The requested comment.", representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the comment", restError=true, responseCode=401), @ResponseDoc(documentation="Unable to find the supplied project, repository, commit or comment. The missing entity will be specified in the error details.", restError=true, responseCode=404)})
    @GET
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getComment(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @PathParam(value="commentId") long commentId) {
        Comment comment = this.doGetComment(repositoryResolver.getRepository(), commitId, commentId);
        return ResponseFactory.ok((Object)new RestComment(comment)).build();
    }

    @Operation(description="Retrieves the commit discussion comments that match the specified search criteria.\n\nIt is possible to retrieve commit discussion comments that are anchored to a range of commits by providing the sinceId that the comments anchored from.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that the commit is in to call this resource.", summary="Search for commit comments")
    @Parameters(value={@Parameter(description="The commit to which the comments must be anchored", in=ParameterIn.PATH, name="commitId"), @Parameter(description="The path to the file on which comments were made", in=ParameterIn.QUERY, name="path"), @Parameter(description="For a merge commit, a parent can be provided to specify which diff the comments are on. For a commit range, a sinceId can be provided to specify where the comments are anchored from.", in=ParameterIn.QUERY, name="since")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of comments that match the search criteria", paged=true, representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the comment", restError=true, responseCode=401), @ResponseDoc(documentation="Unable to find the supplied project, repository, or commit. The missing entity will be specified in the error details.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getComments(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="path") String path, @QueryParam(value="since") String sinceId, @BeanParam PageRequestResolver pageRequestResolver) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comments.findrequirespath", new Object[0]));
        }
        CommitDiscussion commentable = this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repositoryResolver.getRepository(), commitId).create(true).build());
        PageRequest pageRequest = pageRequestResolver.getPageRequest();
        if (commentable == null) {
            return ResponseFactory.ok((Object)new RestPage(PageUtils.createEmptyPage((PageRequest)pageRequest))).build();
        }
        Page threads = this.commentService.searchThreads(new CommentSearchRequest.Builder((Commentable)commentable).fromHash(sinceId).path(path).toHash(commitId).build(), pageRequest);
        return ResponseFactory.ok((Object)new RestPage(PageUtils.createPage((Iterable)((Iterable)threads.stream().map(RestComment::new).collect(MoreCollectors.toImmutableList())), (boolean)threads.getIsLastPage(), (PageRequest)pageRequest))).build();
    }

    @Operation(description="Update a comment, with the following restrictions:\n\n- only the author of the comment may update the <i>text</i> of the comment\n- only the author of the comment or repository admins and above may update the other   fields of a comment\n\n\n<strong>Note:</strong> the supplied supplied JSON object must contain a <code>version</code> that must match the server's version of the comment or the update will fail. To determine the current version of the comment, the comment should be fetched from the server prior to the update. Look for the 'version' attribute in the returned JSON structure.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository that the commit is in to call this resource.", summary="Update a commit comment")
    @Parameters(value={@Parameter(description="The ID of the comment to retrieve", in=ParameterIn.PATH, name="commentId")})
    @RequestBody(description="The comment to update", content={@Content(schema=@Schema(implementation=RestComment.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly updated comment.", representation=RestComment.class, responseCode=200), @ResponseDoc(documentation="The comment was not updated due to a validation error.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the commit, update the comment or watch the commit.", restError=true, responseCode=401), @ResponseDoc(documentation="Unable to find the supplied project, repository, commit or comment. The missing entity will be specified in the error details.", restError=true, responseCode=404), @ResponseDoc(documentation="The comment version supplied does not match the current version or the repository is archived.", restError=true, responseCode=409)})
    @PUT
    @Path(value="{commentId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateComment(@BeanParam RepositoryResolver repositoryResolver, @BeanParam CommentResolver commentResolver, @PathParam(value="commitId") String commitId, RestComment restComment) {
        CommitDiscussion discussion = this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repositoryResolver.getRepository(), commitId).create(false).build());
        Comment comment = commentResolver.getComment();
        if (!comment.getThread().getCommentable().equals((Object)discussion)) {
            throw this.noSuchCommentException(comment.getId());
        }
        Comment updated = this.commentService.updateComment(new CommentUpdateRequest.Builder(comment.getId()).severity(this.toSeverity(restComment.getSeverity())).state(this.toCommentState(restComment.getState(), CommentState.OPEN, CommentState.RESOLVED)).text(restComment.getText()).version(restComment.getVersion()).threadResolved(restComment.hasThreadResolved() ? Boolean.valueOf(restComment.isThreadResolved()) : null).build());
        return ResponseFactory.ok((Object)new RestComment(updated)).build();
    }

    @Nonnull
    private static List<String> toUppercaseNames(@Nonnull Enum[] values) {
        return (List)Arrays.stream(values).map(value -> value.name().toUpperCase(Locale.ROOT)).collect(MoreCollectors.toImmutableList());
    }

    private Comment doGetComment(Repository repository, String commitId, long commentId) {
        CommitDiscussion discussion;
        Optional comment = this.commentService.getComment(commentId);
        if (comment.isPresent() && Objects.equals(discussion = this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repository, commitId).create(false).build()), ((Comment)comment.get()).getThread().getCommentable())) {
            return (Comment)comment.get();
        }
        throw this.noSuchCommentException(commentId);
    }

    private NotFoundException noSuchCommentException(long comment) {
        return new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchcomment", new Object[]{comment}));
    }

    @Nullable
    private CommentState toCommentState(@Nonnull String commentState, CommentState ... validStates) {
        try {
            return StringUtils.isEmpty((CharSequence)commentState) ? null : CommentState.valueOf((String)commentState.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comment.invalidstate", new Object[]{commentState, CommitCommentResource.toUppercaseNames((Enum[])validStates)}));
        }
    }

    @Nullable
    private CommentSeverity toSeverity(@Nonnull String severity) {
        try {
            return StringUtils.isEmpty((CharSequence)severity) ? null : CommentSeverity.valueOf((String)severity.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.comment.invalidseverity", new Object[]{severity, CommitCommentResource.toUppercaseNames((Enum[])CommentSeverity.values())}));
        }
    }

    private void validateLineAnchor(RestCommentThreadDiffAnchor anchor) {
        if (anchor.getLine() < 1) {
            throw new BadRequestException("anchor.line", this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidline", new Object[]{anchor.getLine()}));
        }
        try {
            if (anchor.getLineType() == null) {
                throw new BadRequestException("anchor.lineType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.emptylinetype", new Object[0]));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("anchor.lineType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidlinetype", new Object[]{anchor.get((Object)"lineType")}));
        }
        try {
            anchor.getFileType();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("anchor.fileType", this.i18nService.getMessage("bitbucket.rest.comment.anchor.invalidfiletype", new Object[]{anchor.get((Object)"fileType")}));
        }
    }
}

