/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiff;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.resolver.DiffContentFilterResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug"), @PathParamDoc(name="commitId", documentation="The <i>full ID</i> of the commit within the repository")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CommitDiffResource {
    private final AvatarEnricher avatarEnricher;
    private final CommitService commitService;
    private final I18nService i18nService;

    @Inject
    public CommitDiffResource(I18nService i18nService, AvatarEnricher avatarEnricher, CommitService commitService) {
        this.avatarEnricher = avatarEnricher;
        this.commitService = commitService;
        this.i18nService = i18nService;
    }

    @Operation(description="Retrieve the diff between two provided revisions.\n\nTo stream a raw text representation of the diff, this endpoint can be called with the request header 'Accept: text/plain'. \n\nNote:</strong> This resource is currently <i>not paged</i>. The server will internally apply a hard cap to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event that the cap is reached, the diff will be cut short and one or more {@code truncated} flags will be set to true on the \"segments\", \"hunks\" and \"diffs\" properties, as well as the top-level object, in the returned JSON response.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get diff between revisions")
    @Parameters(value={@Parameter(description="The path to the file which should be diffed (optional)", in=ParameterIn.PATH, name="path"), @Parameter(description="<code>true</code> to automatically try to find the source path when it's not provided, <code>false</code> otherwise. Requires the path to be provided.", in=ParameterIn.QUERY, name="autoSrcPath"), @Parameter(description="If present the service adds avatar URLs for comment authors where the provided value specifies the desired avatar size in pixels. Not applicable if streaming raw diff", in=ParameterIn.QUERY, name="avatarSize"), @Parameter(description="The security scheme for avatar URLs. If the scheme is not present then it is inherited from the request. It can be set to \"https\" to force the use of secure URLs. Not applicable if streaming raw diff", in=ParameterIn.QUERY, name="avatarScheme"), @Parameter(description="The number of context lines to include around added/removed lines in the diff.Not applicable if streaming raw diff", in=ParameterIn.QUERY, name="contextLines"), @Parameter(description="Text used to filter files and lines (optional). Not applicable if streaming raw diff", in=ParameterIn.QUERY, name="filter"), @Parameter(description="The base revision to diff from. If omitted the parent revision of the until revision is used", in=ParameterIn.QUERY, name="since"), @Parameter(description="The source path for the file, if it was copied, moved or renamed", in=ParameterIn.QUERY, name="srcPath"), @Parameter(description="Optional whitespace flag which can be set to ignore-all", in=ParameterIn.QUERY, name="whitespace"), @Parameter(description="<code>true</code> to embed comments in the diff (the default); otherwise <code>false</code> to stream the diff without comments. Not applicable if streaming raw diff", in=ParameterIn.QUERY, name="withComments")})
    @ResponseDocs(value={@ResponseDoc(documentation="A diff between two revisions.", representation=RestDiff.class, responseCode=200), @ResponseDoc(documentation="The until parameter was not supplied.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="commitId") String untilId, final @PathParam(value="path") String path, final @QueryParam(value="autoSrcPath") @DefaultValue(value="false") boolean autoSrcPath, final @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, final @QueryParam(value="since") String sinceId, final @QueryParam(value="srcPath") String srcPath, final @QueryParam(value="whitespace") String whitespace, final @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="avatarScheme") String avatarScheme, final @BeanParam DiffContentFilterResolver filterResolver, final @Context ContainerRequestContext request) {
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) {
                Function<Comment, RestComment> commentTransformer = CommitDiffResource.this.createAvatarCommentTransformer(request);
                DiffRequest.Builder builder = ((DiffRequest.Builder)new DiffRequest.Builder(repositoryResolver.getRepository(), untilId).contextLines(contextLines).filter(filterResolver.getDiffContentFilter())).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace)).withComments(withComments);
                if (StringUtils.isNotBlank((CharSequence)srcPath)) {
                    builder.path(srcPath);
                } else if (autoSrcPath) {
                    if (StringUtils.isBlank((CharSequence)path)) {
                        throw new ArgumentValidationException(CommitDiffResource.this.i18nService.createKeyedMessage("bitbucket.rest.commits.autoscrpathrequirespath", new Object[0]));
                    }
                    builder.autoSrcPath(true);
                }
                DiffRequest diffRequest = builder.build();
                CommitDiffResource.this.commitService.streamDiff(diffRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, commentTransformer));
            }
        }, (CacheControl)(withComments ? CachePolicies.noCache() : CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId))).build();
    }

    @GET
    @Hidden
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String untilId, @QueryParam(value="autoSrcPath") @DefaultValue(value="false") boolean autoSrcPath, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @BeanParam DiffContentFilterResolver filterResolver, @Context ContainerRequestContext request) {
        return this.streamDiff(repositoryResolver, untilId, null, autoSrcPath, contextLines, sinceId, srcPath, whitespace, withComments, "", "", filterResolver, request);
    }

    @GET
    @Hidden
    @Path(value="{path:.*}")
    @Produces(value={"text/plain; qs=0.1"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String untilId, @PathParam(value="path") String path, @QueryParam(value="autoSrcPath") @DefaultValue(value="false") boolean autoSrcPath, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace) {
        DiffRequest.Builder builder = new DiffRequest.Builder(repositoryResolver.getRepository(), untilId).contextLines(contextLines).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace));
        if (StringUtils.isNotBlank((CharSequence)srcPath)) {
            builder.path(srcPath);
        } else if (autoSrcPath) {
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.commits.autoscrpathrequirespath", new Object[0]));
            }
            builder.autoSrcPath(true);
        }
        return ResponseFactory.ok((headers, output) -> this.commitService.streamDiff(builder.build(), contentType -> {
            headers.putSingle((Object)"Content-Type", (Object)contentType);
            return output;
        }), (CacheControl)CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId)).build();
    }

    @GET
    @Hidden
    @Produces(value={"text/plain; qs=0.1"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String untilId, @QueryParam(value="autoSrcPath") @DefaultValue(value="false") boolean autoSrcPath, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace) {
        return this.streamRawDiff(repositoryResolver, untilId, null, autoSrcPath, contextLines, sinceId, srcPath, whitespace);
    }

    private Function<Comment, RestComment> createAvatarCommentTransformer(ContainerRequestContext request) {
        final AvatarRequest avatarRequest = AvatarRequestHelper.makeAvatarRequest((ContainerRequestContext)request, (I18nService)this.i18nService);
        if (avatarRequest == null) {
            return RestComment.REST_TRANSFORM;
        }
        return new Function<Comment, RestComment>(){

            @Override
            public RestComment apply(Comment comment) {
                RestComment restComment = new RestComment(comment, (Function)this);
                CommitDiffResource.this.avatarEnricher.enrich((Object)restComment, avatarRequest);
                return restComment;
            }
        };
    }
}

