/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommonAncestorRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/merge-base")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug"), @PathParamDoc(name="commitId", documentation="The <i>full ID</i> of the commit within the repository")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CommitMergeBaseResource {
    private final CommitService commitService;
    private final I18nService i18nService;

    @Inject
    public CommitMergeBaseResource(CommitService commitService, I18nService i18nService) {
        this.commitService = commitService;
        this.i18nService = i18nService;
    }

    @Operation(description="Returns the best common ancestor between two commits.\n\nIf more than one best common ancestor exists, only one will be returned. It is unspecified which will be returned.", summary="Get the common ancestor between two commits")
    @Parameters(value={@Parameter(description="The first commit id to calculate the merge-base on", in=ParameterIn.PATH, name="commitId"), @Parameter(description="The other commit id to calculate the merge-base on", in=ParameterIn.QUERY, name="otherCommitId")})
    @ResponseDocs(value={@ResponseDoc(documentation="The common ancestor of the two given commits", representation=RestCommit.class, responseCode=200), @ResponseDoc(documentation="No common parent between the two commits exist", responseCode=204), @ResponseDoc(documentation="The supplied commit ID(s) was/were invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The project, repository, or commit(s) does not exist", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMergeBase(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="otherCommitId") String otherCommitId) {
        CommonAncestorRequest request = new CommonAncestorRequest.Builder(repositoryResolver.getRepository()).commitId(this.requireNotBlank(commitId, "commitId").trim(), new String[0]).commitId(this.requireNotBlank(otherCommitId, "otherCommitId").trim(), new String[0]).build();
        return this.commitService.getCommonAncestor(request).map(minimalCommit -> {
            Commit commit = this.commitService.getCommit(new CommitRequest.Builder(repositoryResolver.getRepository(), minimalCommit.getId()).build());
            return Response.ok().entity((Object)new RestCommit(commit));
        }).orElse(Response.noContent()).build();
    }

    @Nonnull
    private String requireNotBlank(String value, String paramName) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.request.param.blank", new Object[]{paramName}));
        }
        return value;
    }
}

