/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.pull.PullRequestCommitSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/pull-requests")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug"), @PathParamDoc(name="commitId", documentation="the commit ID")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Pull Requests")
public class CommitPullRequestResource {
    private final PullRequestService pullRequestService;

    @Inject
    public CommitPullRequestResource(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    @Operation(description="Retrieve a page of pull requests in the current repository that contain the given commit.\n\nThe user must be authenticated and have access to the specified repository to call this resource.", summary="Get repository pull requests containing commit")
    @ResponseDocs(value={@ResponseDoc(documentation="Return a page of pull requests in the current repository containing the given commit.", paged=true, representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to see the request repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The request repository does not exist", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequests(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @BeanParam PageRequestResolver pageRequestResolver) {
        PullRequestCommitSearchRequest searchRequest = new PullRequestCommitSearchRequest.Builder(commitId).toRepositoryId(Integer.valueOf(repositoryResolver.getRepository().getId())).build();
        Page pullRequestPage = this.pullRequestService.searchByCommit(searchRequest, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(pullRequestPage, RestPullRequest.REST_TRANSFORM)).build();
    }
}

