/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.DiffStatsSummaryRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiffStatsSummary;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.pull.JsonCommitCallback;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CommitResource {
    static final String PARAM_PROJECT_KEY = "secondaryProjectKey";
    static final String PARAM_REPOSITORY_ID = "secondaryRepositoryId";
    static final String PARAM_REPOSITORY_SLUG = "secondaryRepositorySlug";
    private final AvatarEnricher avatarEnricher;
    private final CommitService commitService;
    private final I18nService i18nService;
    private final LinkEnricher linkEnricher;
    private final ProjectService projectService;
    private final RefService refService;
    private final RepositoryService repositoryService;

    @Inject
    public CommitResource(AvatarEnricher avatarEnricher, CommitService commitService, I18nService i18nService, LinkEnricher linkEnricher, ProjectService projectService, RefService refService, RepositoryService repositoryService) {
        this.avatarEnricher = avatarEnricher;
        this.commitService = commitService;
        this.i18nService = i18nService;
        this.linkEnricher = linkEnricher;
        this.projectService = projectService;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Retrieve a page of commits from a given starting commit or \"between\" two commits. If no explicit commit is specified, the tip of the repository's default branch is assumed. commits may be identified by branch or tag name or by ID. A path may be supplied to restrict the returned commits to only those which affect that path. \n\nThe authenticated user must have <b>REPO_READ</b> permission for the specified repository to call this resource.", summary="Get commits")
    @Parameters(value={@Parameter(description="If present the service adds avatar URLs for commit authors. Should be an integer specifying the desired size in pixels. If the parameter is not present, avatar URLs will not be set", in=ParameterIn.QUERY, name="avatarSize"), @Parameter(description="The desired scheme for the avatar URL. If the parameter is not present URLs will use the same scheme as this request", in=ParameterIn.QUERY, name="avatarScheme"), @Parameter(description="The commit ID (SHA1) or ref (inclusively) to retrieve commits before", in=ParameterIn.QUERY, name="until"), @Parameter(description="If <code>true</code>, the commit history of the specified file will be followed past renames. Only valid for a path to a single file.", in=ParameterIn.QUERY, name="followRenames"), @Parameter(description="<code>true</code> to ignore missing commits, <code>false</code> otherwise", in=ParameterIn.QUERY, name="ignoreMissing"), @Parameter(description="If present, controls how merge commits should be filtered. Can be either <code>exclude</code>, to exclude merge commits, <code>include</code>, to include both merge commits and non-merge commits or <code>only</code>, to only return merge commits.", in=ParameterIn.QUERY, name="merges"), @Parameter(description="The commit ID or ref (exclusively) to retrieve commits after", in=ParameterIn.QUERY, name="since"), @Parameter(description="An optional path to filter commits by", in=ParameterIn.QUERY, name="path"), @Parameter(description="Optionally include the total number of commits and total number of unique authors", in=ParameterIn.QUERY, name="withCounts")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of commits", representation=RestCommit.class, paged=true, responseCode=200), @ResponseDoc(documentation="One of the supplied commit IDs or refs was invalid.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository does not exist.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCommits(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="followRenames") @DefaultValue(value="false") boolean followRenames, @QueryParam(value="ignoreMissing") @DefaultValue(value="false") boolean ignoreMissing, @QueryParam(value="merges") String merges, @QueryParam(value="path") String path, @QueryParam(value="since") String parentId, @QueryParam(value="until") String commitId, final @QueryParam(value="withCounts") @DefaultValue(value="false") boolean withCounts, @QueryParam(value="avatarSize") String avatarSize, @QueryParam(value="avatarScheme") String avatarScheme, final @BeanParam PageRequestResolver pageRequestResolver, final @Context ContainerRequestContext requestContext) {
        boolean useDefault = StringUtils.isBlank((CharSequence)commitId);
        Repository repository = repositoryResolver.getRepository();
        if (useDefault && this.repositoryService.isEmpty(repository)) {
            return ResponseFactory.ok((Object)new RestPage(PageUtils.createEmptyPage((PageRequest)pageRequestResolver.getPageRequest()))).build();
        }
        if (followRenames && StringUtils.isBlank((CharSequence)path)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.commits.followrequirespath", new Object[0]));
        }
        Repository secondaryRepository = this.getSecondaryRepository(requestContext.getUriInfo(), repositoryResolver.getRepository());
        final CommitsBetweenRequest.Builder builder = ((CommitsBetweenRequest.Builder)((CommitsBetweenRequest.Builder)((CommitsBetweenRequest.Builder)new CommitsBetweenRequest.Builder(repository).exclude(parentId, new String[0]).followRenames(followRenames)).ignoreMissing(ignoreMissing)).include(useDefault ? this.refService.getDefaultBranch(repository).getLatestCommit() : commitId, new String[0]).path(path)).secondaryRepository(secondaryRepository);
        if (merges != null) {
            CommitListMergeFilter mergeFilter = CommitListMergeFilter.fromString((String)merges, null);
            if (mergeFilter == null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.commits.mergefilter.invalid", new Object[]{merges, this.toLowercaseNames((Enum[])CommitListMergeFilter.values())}));
            }
            builder.merges(mergeFilter);
        }
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws WebApplicationException {
                Function<Commit, RestCommit> commitTransformer = RestCommit.createTransformer((ContainerRequestContext)requestContext, (AvatarEnricher)CommitResource.this.avatarEnricher, (I18nService)CommitResource.this.i18nService).andThen(commit -> {
                    CommitResource.this.linkEnricher.enrich(commit);
                    return commit;
                });
                CommitResource.this.commitService.streamCommitsBetween(builder.build(), (CommitCallback)new JsonCommitCallback(writer, commitTransformer, withCounts, pageRequestResolver.getPageRequest()));
            }
        }).build();
    }

    @Operation(description="Retrieve a single commit <i>identified by its ID</i>. In general, that ID is a SHA1. <u>From 2.11, ref names like \"refs/heads/master\" are no longer accepted by this resource.</u>\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get commit by ID")
    @Parameters(value={@Parameter(description="The commit ID to retrieve", in=ParameterIn.PATH, name="commitId"), @Parameter(description="An optional path to filter the commit by. If supplied the details returned <i>may not</i> be for the specified commit. Instead, starting from the specified commit, they will be the details for the first commit affecting the specified path.", in=ParameterIn.QUERY, name="path")})
    @ResponseDocs(value={@ResponseDoc(documentation="A commit", representation=RestCommit.class, responseCode=200), @ResponseDoc(documentation="The supplied commit ID was invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The repository does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="{commitId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCommit(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="path") String path) {
        if (StringUtils.isBlank((CharSequence)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.commits.commitid.required", new Object[0]));
        }
        Commit commit = this.commitService.getCommit(new CommitRequest.Builder(repositoryResolver.getRepository(), commitId).path(path).build());
        return ResponseFactory.ok((Object)new RestCommit(commit)).build();
    }

    @GET
    @Hidden
    @Path(value="{commitId}/diff-stats-summary")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDiffStatsSummary(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String untilId, @QueryParam(value="since") String sinceId, @QueryParam(value="whitespace") String whitespace) {
        return this.getDiffStatsSummary(repositoryResolver, untilId, null, false, sinceId, null, whitespace);
    }

    @Operation(description="Retrieve the diff stats summary for a commit.\n\nThe stats summary include the total number of modified files, added lines, and deleted lines. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get diff stats summary between revisions")
    @Parameters(value={@Parameter(description="The commit ID to diff to.", in=ParameterIn.PATH, name="commitId"), @Parameter(description="The path to the file which should be diffed (optional)", in=ParameterIn.PATH, name="path"), @Parameter(description="<code>true</code> to automatically try to find the source path when it's not provided, <code>false</code> otherwise. Requires the path to be provided.", in=ParameterIn.QUERY, name="autoSrcPath"), @Parameter(description="The base revision to diff from. If omitted the parent revision of the commit ID is used", in=ParameterIn.QUERY, name="since"), @Parameter(description="The source path for the file, if it was copied, moved or renamed", in=ParameterIn.QUERY, name="srcPath"), @Parameter(description="Optional whitespace flag which can be set to ignore-all", in=ParameterIn.QUERY, name="whitespace")})
    @ResponseDocs(value={@ResponseDoc(documentation="The diff stats summary for a commit.", representation=RestDiffStatsSummary.class, responseCode=200), @ResponseDoc(documentation="The until parameter was not supplied.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="{commitId}/diff-stats-summary/{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDiffStatsSummary(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String untilId, @PathParam(value="path") String path, @QueryParam(value="autoSrcPath") @DefaultValue(value="false") boolean autoSrcPath, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace) {
        DiffStatsSummaryRequest.Builder builder = new DiffStatsSummaryRequest.Builder(repositoryResolver.getRepository(), untilId).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace));
        if (StringUtils.isNotBlank((CharSequence)srcPath)) {
            builder.path(srcPath);
        } else if (autoSrcPath) {
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.commits.autoscrpathrequirespath", new Object[0]));
            }
            builder.autoSrcPath(true);
        }
        DiffStatsSummary diffStatsSummary = this.commitService.getDiffStatsSummary(builder.build());
        return ResponseFactory.ok((Object)new RestDiffStatsSummary(diffStatsSummary), (CacheControl)CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId)).build();
    }

    private List<String> toLowercaseNames(Enum[] values) {
        return (List)Arrays.stream(values).map(value -> value.name().toLowerCase(Locale.ROOT)).collect(MoreCollectors.toImmutableList());
    }

    @VisibleForTesting
    Repository getSecondaryRepository(UriInfo uriInfo, Repository primaryRepository) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String id = (String)queryParameters.getFirst((Object)PARAM_REPOSITORY_ID);
        if (id != null) {
            Repository repository = this.repositoryService.getById(Integer.parseInt(id));
            if (repository == null) {
                throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyid", new Object[]{id}), (Project)null);
            }
            return repository;
        }
        String pathProjectKey = primaryRepository.getProject().getKey();
        String pathRepositorySlug = primaryRepository.getSlug();
        String projectKey = (String)queryParameters.getFirst((Object)PARAM_PROJECT_KEY);
        String repositorySlug = (String)queryParameters.getFirst((Object)PARAM_REPOSITORY_SLUG);
        if (projectKey == null) {
            projectKey = pathProjectKey;
        }
        if (repositorySlug == null) {
            repositorySlug = pathRepositorySlug;
        }
        if (projectKey.equals(pathProjectKey) && repositorySlug.equals(pathRepositorySlug)) {
            return null;
        }
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        if (repository == null) {
            Project project = this.projectService.getByKey(projectKey);
            if (project == null) {
                throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchproject.secondarybykey", new Object[]{projectKey}));
            }
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyslug", new Object[]{projectKey, repositorySlug});
            throw new NoSuchRepositoryException(message, project);
        }
        return repository;
    }
}

