/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug"), @PathParamDoc(name="commitId", documentation="The <i>full ID</i> of the commit within the repository")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class CommitWatchResource {
    private final CommitService commitService;
    private final WatcherService watcherService;

    @Inject
    public CommitWatchResource(CommitService commitService, WatcherService watcherService) {
        this.commitService = commitService;
        this.watcherService = watcherService;
    }

    @Operation(description="Add the authenticated user as a watcher for the specified commit.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository containing the commit to call this resource.", summary="Watch commit")
    @ResponseDocs(value={@ResponseDoc(documentation="The user is now watching the commit.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project, repository or commit does not exist.", restError=true, responseCode=404)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response watch(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId) {
        this.getDiscussion(repositoryResolver.getRepository(), commitId, true).ifPresent(discussion -> this.watcherService.watch(new WatchRequest.Builder((Watchable)discussion).build()));
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Remove the authenticated user as a watcher for the specified commit.\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the repository containing the commit to call this resource.", summary="Stop watching commit")
    @ResponseDocs(value={@ResponseDoc(documentation="The user is no longer watching the commit.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the pull request.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project, repository or commit does not exist.", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response unwatch(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId) {
        this.getDiscussion(repositoryResolver.getRepository(), commitId, false).ifPresent(discussion -> this.watcherService.unwatch(new UnwatchRequest.Builder((Watchable)discussion).build()));
        return ResponseFactory.noContent().build();
    }

    private Optional<CommitDiscussion> getDiscussion(Repository repository, String commitId, boolean create) {
        return Optional.ofNullable(this.commitService.getDiscussion(new CommitDiscussionRequest.Builder(repository, commitId).create(create).build()));
    }
}

