/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.LastModifiedCallback;
import com.atlassian.bitbucket.commit.LastModifiedContext;
import com.atlassian.bitbucket.commit.LastModifiedSummary;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;

class JsonLastModifiedCallback
implements LastModifiedCallback {
    private final Function<Commit, RestCommit> commitTransformer;
    private final StatefulJsonWriter writer;
    private volatile boolean committed;
    private boolean started;

    JsonLastModifiedCallback(StatefulJsonWriter writer, Function<Commit, RestCommit> commitTransformer) {
        this.writer = writer;
        this.commitTransformer = commitTransformer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void onEnd(@Nonnull LastModifiedSummary summary) throws IOException {
        if (this.started) {
            this.writer.endObject().name("latestCommit");
            Optional latestCommit = summary.getLatestCommit();
            if (latestCommit.isPresent()) {
                this.writer.value((Object)this.commitTransformer.apply((Commit)latestCommit.get()));
            } else {
                this.writer.nullValue();
            }
            this.writer.endObject();
        }
    }

    public boolean onFile(@Nonnull String file, @Nonnull Commit commit) throws IOException {
        if (this.started) {
            this.writer.name(file).value((Object)this.commitTransformer.apply(commit));
        }
        return true;
    }

    public void onStart(@Nonnull LastModifiedContext context) throws IOException {
        this.committed = true;
        this.writer.beginObject().name("files").beginObject();
        this.started = true;
    }
}

