/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.LastModifiedCallback;
import com.atlassian.bitbucket.commit.LastModifiedRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.commit.JsonLastModifiedCallback;
import com.google.common.base.Throwables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/last-modified")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class LastModifiedResource {
    private static final Logger log = LoggerFactory.getLogger(LastModifiedResource.class);
    private final AvatarEnricher avatarEnricher;
    private final CommitService commitService;
    private final I18nService i18nService;

    @Inject
    public LastModifiedResource(AvatarEnricher avatarEnricher, CommitService commitService, I18nService i18nService) {
        this.avatarEnricher = avatarEnricher;
        this.commitService = commitService;
        this.i18nService = i18nService;
    }

    @Operation(description="Streams files in the requested <code>path</code> with the last commit to modify each file. Commit modifications are traversed starting from the <code>at</code> commit or, if not specified, from the tip of the default branch.\n\nUnless the repository is public, the authenticated user must have <b>REPO_READ</b> access to call this resource.", summary="Stream files with last modified commit in path")
    @Parameters(value={@Parameter(description="The path within the repository whose files should be streamed", in=ParameterIn.PATH, name="path"), @Parameter(description="The commit to use as the starting point when listing files and calculating modifications", in=ParameterIn.QUERY, name="at")})
    @ResponseDocs(value={@ResponseDoc(documentation="A map of files to the last commit that modified them, and the latest commit to update the requested path.", representation=ExampleFiles.class, responseCode=200), @ResponseDoc(documentation="No <code>at</code> commit was specified. When streaming modifications, an explicit starting commit must be supplied.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository does not exist or does not contain the <code>at</code> commit, or the <code>at</code> commit does not contain the requested path.", restError=true, responseCode=404)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response stream(@BeanParam RepositoryResolver repositoryResolver, final @Context ContainerRequestContext request, final @QueryParam(value="at") String commitId, final @PathParam(value="path") String path) {
        if (StringUtils.isBlank((CharSequence)commitId)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.lastmodified.startingcommitrequired", new Object[0]));
        }
        final Repository repository = repositoryResolver.getRepository();
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                JsonLastModifiedCallback callback = new JsonLastModifiedCallback(writer, RestCommit.createTransformer((ContainerRequestContext)request, (AvatarEnricher)LastModifiedResource.this.avatarEnricher, (I18nService)LastModifiedResource.this.i18nService));
                try {
                    LastModifiedResource.this.commitService.streamLastModified(((LastModifiedRequest.Builder)new LastModifiedRequest.Builder(repository, commitId).path(path)).build(), (LastModifiedCallback)callback);
                }
                catch (ServiceException e) {
                    if (callback.isCommitted()) {
                        this.logException(e);
                    }
                    throw e;
                }
            }

            private void logException(ServiceException e) {
                Throwable trigger = Throwables.getCausalChain((Throwable)e).stream().filter(cause -> cause instanceof CommandTimeoutException).findFirst().orElse(null);
                if (trigger instanceof CommandTimeoutException) {
                    log.info("{}: Timed out streaming last modified data for {}:{}", new Object[]{repository, commitId, StringUtils.defaultString((String)path)});
                } else {
                    log.warn("{}: Failed to stream last modified data for {}:{}", new Object[]{repository, commitId, StringUtils.defaultString((String)path), e});
                }
            }
        }, (CacheControl)CachePolicies.getCacheControlForObjectId((String)commitId)).build();
    }

    @Operation(description="Streams files from the repository's root with the last commit to modify each file. Commit modifications are traversed starting from the <code>at</code> commit or, if not specified, from the tip of the default branch.\n\nUnless the repository is public, the authenticated user must have <b>REPO_READ</b> access to call this resource.", summary="Stream files")
    @Parameters(value={@Parameter(description="The commit to use as the starting point when listing files and calculating modifications", in=ParameterIn.QUERY, name="at")})
    @ResponseDocs(value={@ResponseDoc(documentation="A map of files to the last commit that modified them, and the latest commit to the repository (by nature, any commit to a repository modifies its root).", representation=ExampleFiles.class, responseCode=200), @ResponseDoc(documentation="No <code>at</code> commit was specified. When streaming modifications, an explicit starting commit must be supplied.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository does not exist or does not contain the <code>at</code> commit.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response stream(@BeanParam RepositoryResolver repositoryResolver, @Context ContainerRequestContext request, @QueryParam(value="at") String commitId) {
        return this.stream(repositoryResolver, request, commitId, null);
    }

    private static class ExampleFiles {
        private ExampleFiles() {
        }

        public ExampleJsonLastModifiedCallback getFiles() {
            throw new RuntimeException("This class should not be invoked");
        }
    }

    private static class ExampleJsonLastModifiedCallback {
        private ExampleJsonLastModifiedCallback() {
        }

        public RestCommit getLatestCommit() {
            throw new RuntimeException("This class should not be invoked");
        }

        public RestCommit getPomXml() {
            throw new RuntimeException("This class should not be invoked");
        }

        public RestCommit getReadmeMd() {
            throw new RuntimeException("This class should not be invoked");
        }
    }
}

