/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.compare;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.compare.CompareDiffRequest;
import com.atlassian.bitbucket.compare.CompareDiffStatsSummaryRequest;
import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.compare.CompareService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.content.RestChange;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiff;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiffStatsSummary;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.resolver.DiffContentFilterResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import com.atlassian.stash.internal.rest.pull.JsonCommitCallback;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/compare")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
public class CompareResource {
    private final AvatarEnricher avatarEnricher;
    private final CompareService compareService;
    private final I18nService i18nService;
    private final RefService refService;
    private final RepositoryService repositoryService;

    @Inject
    public CompareResource(AvatarEnricher avatarEnricher, CompareService compareService, I18nService i18nService, RefService refService, RepositoryService repositoryService) {
        this.avatarEnricher = avatarEnricher;
        this.compareService = compareService;
        this.i18nService = i18nService;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Retrieve the diff stats summary of the changes available in the <code>from</code> commit but not in the <code> to</code> commit.\n\nIf either the <code> from</code> or <code> to</code> commit are not specified, they will be replaced by the default branch of their containing repository.", summary="Retrieve the diff stats summary between commits")
    @Parameters(value={@Parameter(description="the source commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="from"), @Parameter(description="the target commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="to"), @Parameter(description="an optional parameter specifying the source repository containing the source commit if that commit is not present in the current repository; the repository can be specified by either its ID <em>fromRepo=42</em> or by its project key plus its repo slug separated by a slash: <em>fromRepo=projectKey/repoSlug</em>", in=ParameterIn.QUERY, name="fromRepo"), @Parameter(description="the path to the file to diff (optional)", in=ParameterIn.PATH, name="path"), @Parameter(description="source path", in=ParameterIn.QUERY, name="srcPath"), @Parameter(description="an optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY, name="whitespace")})
    @ResponseDocs(value={@ResponseDoc(documentation="The diff stats summary for the changes.", representation=RestDiff.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The source repository,target repository, or commit does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="/diff-stats-summary{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDiffStatsSummary(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, @PathParam(value="path") String path, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace, @Context ContainerRequestContext request) {
        path = StringUtils.removeStart((String)path, (String)"/");
        Repository fromRepository = this.getSourceRepository(fromRepo, repositoryResolver.getRepository());
        CompareDiffStatsSummaryRequest compareRequest = new CompareDiffStatsSummaryRequest.Builder().fromRef(this.toCompareRef(from, fromRepository)).toRef(this.toCompareRef(to, repositoryResolver.getRepository())).paths(path, new String[]{srcPath}).whitespace(DiffWhitespace.fromString((String)whitespace)).build();
        return ResponseFactory.ok((Object)new RestDiffStatsSummary(this.compareService.getDiffStatsSummary(compareRequest)), (CacheControl)CompareResource.getCacheControl(compareRequest.getFromRef(), compareRequest.getToRef())).build();
    }

    @Operation(description="Gets the file changes available in the <code> from</code> commit but not in the <code> to</code> commit.\n\n\nIf either the <code> from</code> or <code> to</code> commit are not specified, they will be replaced by the default branch of their containing repository.", summary="Compare commits")
    @Parameters(value={@Parameter(description="the source commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="from"), @Parameter(description="the target commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="to"), @Parameter(description="an optional parameter specifying the source repository containing the source commit if that commit is not present in the current repository; the repository can be specified by either its ID <em>fromRepo=42</em> or by its project key plus its repo slug separated by a slash: <em>fromRepo=projectKey/repoSlug</em>", in=ParameterIn.QUERY, name="fromRepo")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of changes.", paged=true, representation=RestChange.class, responseCode=200), @ResponseDoc(documentation="The source repository,target repository, or commit does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="/changes")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamChanges(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, final @BeanParam PageRequestResolver pageRequestResolver) {
        final CompareRequest compareRequest = this.toCompareRequest(from, fromRepo, to, repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CompareResource.this.compareService.streamChanges(compareRequest, (ChangeCallback)new JsonChangeCallback(writer, pageRequestResolver.getPageRequest()));
            }
        }, (CacheControl)this.compareCachePolicy(compareRequest)).build();
    }

    @Operation(description="Gets the commits accessible from the <code>from</code> commit but not in the <code>to</code> commit.\n\nIf either the <code>from</code> or <code>to</code> commit are not specified, they will be replaced by the default branch of their containing repository.", summary="Get accessible commits")
    @Parameters(value={@Parameter(description="the source commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="from"), @Parameter(description="the target commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="to"), @Parameter(description="an optional parameter specifying the source repository containing the source commit if that commit is not present in the current repository; the repository can be specified by either its ID <em>fromRepo=42</em> or by its project key plus its repo slug separated by a slash: <em>fromRepo=projectKey/repoSlug</em>", in=ParameterIn.QUERY, name="fromRepo")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of commits.", paged=true, representation=RestCommit.class, responseCode=200), @ResponseDoc(documentation="The source repository,target repository, or commit does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="/commits")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamCommits(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, final @BeanParam PageRequestResolver pageRequestResolver, final @Context ContainerRequestContext request) {
        final CompareRequest compareRequest = this.toCompareRequest(from, fromRepo, to, repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CompareResource.this.compareService.streamCommits(compareRequest, (CommitCallback)new JsonCommitCallback(writer, RestCommit.createTransformer((ContainerRequestContext)request, (AvatarEnricher)CompareResource.this.avatarEnricher, (I18nService)CompareResource.this.i18nService), false, pageRequestResolver.getPageRequest()));
            }
        }).build();
    }

    @Operation(description="Gets a diff of the changes available in the <code>from</code> commit but not in the <code> to</code> commit.\n\nIf either the <code> from</code> or <code> to</code> commit are not specified, they will be replaced by the default branch of their containing repository.", summary="Get diff between commits")
    @Parameters(value={@Parameter(description="the source commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="from"), @Parameter(description="the target commit (can be a partial/full commit ID or qualified/unqualified ref name)", in=ParameterIn.QUERY, name="to"), @Parameter(description="an optional parameter specifying the source repository containing the source commit if that commit is not present in the current repository; the repository can be specified by either its ID <em>fromRepo=42</em> or by its project key plus its repo slug separated by a slash: <em>fromRepo=projectKey/repoSlug</em>", in=ParameterIn.QUERY, name="fromRepo"), @Parameter(description="the path to the file to diff (optional)", in=ParameterIn.PATH, name="path"), @Parameter(description="source path", in=ParameterIn.QUERY, name="srcPath"), @Parameter(description="an optional number of context lines to include around each added or removed lines in the diff", in=ParameterIn.QUERY, name="contextLines"), @Parameter(description="an optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY, name="whitespace")})
    @ResponseDocs(value={@ResponseDoc(documentation="The diff of the changes.", representation=RestDiff.class, responseCode=200), @ResponseDoc(documentation="The source repository,target repository, or commit does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="/diff{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, @PathParam(value="path") String path, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="whitespace") String whitespace, @BeanParam DiffContentFilterResolver filterResolver, @Context ContainerRequestContext request) {
        path = StringUtils.removeStart((String)path, (String)"/");
        Repository fromRepository = this.getSourceRepository(fromRepo, repositoryResolver.getRepository());
        final CompareDiffRequest compareRequest = ((CompareDiffRequest.Builder)((CompareDiffRequest.Builder)((CompareDiffRequest.Builder)((CompareDiffRequest.Builder)new CompareDiffRequest.Builder().fromRef(this.toCompareRef(from, fromRepository)).filter(filterResolver.getDiffContentFilter())).toRef(this.toCompareRef(to, repositoryResolver.getRepository())).paths(path, new String[]{srcPath})).contextLines(contextLines)).whitespace(DiffWhitespace.fromString((String)whitespace))).build();
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CompareResource.this.compareService.streamDiff(compareRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, RestComment.REST_TRANSFORM));
            }
        }, (CacheControl)this.compareCachePolicy(compareRequest)).build();
    }

    private CacheControl compareCachePolicy(CompareRequest compareRequest) {
        return CompareResource.getCacheControl(compareRequest.getFromRef(), compareRequest.getToRef());
    }

    private CacheControl compareCachePolicy(CompareDiffRequest compareDiffRequest) {
        return CompareResource.getCacheControl(compareDiffRequest.getFromRef(), compareDiffRequest.getToRef());
    }

    @VisibleForTesting
    protected static CacheControl getCacheControl(CompareRef fromRef, CompareRef toRef) {
        if (toRef.getId() == null) {
            return CachePolicies.noCache();
        }
        return CachePolicies.getCacheControlForRange((String)fromRef.getId(), (String)toRef.getId());
    }

    private Repository getSourceRepository(String fromRepo, Repository toRepository) {
        Repository repository;
        if (Strings.isNullOrEmpty((String)fromRepo)) {
            repository = toRepository;
        } else {
            Integer repositoryId = Ints.tryParse((String)fromRepo);
            if (repositoryId != null) {
                repository = this.repositoryService.getById(repositoryId.intValue());
                if (repository == null) {
                    throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyid", new Object[]{repositoryId}), null);
                }
            } else {
                String repositorySlug;
                int p = fromRepo.indexOf(47);
                String projectKey = StringUtils.substring((String)fromRepo, (int)0, (int)p);
                repository = this.repositoryService.getBySlug(projectKey, repositorySlug = StringUtils.substring((String)fromRepo, (int)(p + 1)));
                if (repository == null) {
                    throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyslug", new Object[]{projectKey, repositorySlug}), null);
                }
            }
        }
        return repository;
    }

    private CompareRef toCompareRef(String id, Repository repository) {
        if (StringUtils.isBlank((CharSequence)id)) {
            try {
                id = this.refService.getDefaultBranch(repository).getId();
            }
            catch (NoDefaultBranchException noDefaultBranchException) {
                // empty catch block
            }
        }
        return new CompareRef(id, repository);
    }

    private CompareRequest toCompareRequest(String from, String fromRepositoryId, String to, Repository toRepository) {
        Repository fromRepository = this.getSourceRepository(fromRepositoryId, toRepository);
        return new CompareRequest.Builder().fromRef(this.toCompareRef(from, fromRepository)).toRef(this.toCompareRef(to, toRepository)).build();
    }
}

