/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.content.ArchiveFormat;
import com.atlassian.bitbucket.content.ArchiveRequest;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.dmz.mirror.MirrorAvailable;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/archive")
@MirrorAvailable
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/octet-stream", "application/x-tar"})
@Singleton
@Tag(name="Repository")
public class ArchiveResource {
    private final ContentService contentService;
    private final I18nService i18nService;
    private final RefService refService;

    @Inject
    public ArchiveResource(ContentService contentService, I18nService i18nService, RefService refService) {
        this.contentService = contentService;
        this.i18nService = i18nService;
        this.refService = refService;
    }

    @Operation(description="Streams an archive of the repository's contents at the requested commit. If no `at=` commit is requested, an archive of the default branch is streamed.\n\nThe <code>filename=</code> query parameter may be used to specify the exact filename to include in the \"Content-Disposition\" header. If an explicit filename is not provided, one will be automatically generated based on what is being archived. Its format depends on the at= value: \n\n- No <code>at=</code> commit:     &lt;slug&gt;-&lt;default-branch-name&gt;@&lt;commit&gt;.&lt;format&gt;;     e.g. example-master@43c2f8a0fe8.zip\n- <code>at=</code>sha: &lt;slug&gt;-&lt;at&gt;.&lt;format&gt;; e.g.     example-09bcbb00100cfbb5310fb6834a1d5ce6cac253e9.tar.gz\n- <code>at=</code>branchOrTag: &lt;slug&gt;-&lt;branchOrTag&gt;@&lt;commit&gt;.&lt;format&gt;;     e.g. example-feature@bbb225f16e1.tar \n\n    - If the branch or tag is qualified (e.g. refs/heads/master, the short name         (master) will be included in the filename\n    - If the branch or tag's <i>short name</i> includes slashes (e.g. release/4.6),         they will be converted to hyphens in the filename (release-4.5)\n\n\n\n\nArchives may be requested in the following formats by adding the <code>format=</code> query parameter: \n\n- zip: A zip file using standard compression (Default)\n- tar: An uncompressed tarball\n- tar.gz or tgz: A GZip-compressed tarball\n\n\nThe contents of the archive may be filtered by using the <code>path=</code> query parameter to specify paths to include. <code>path=</code> may be specified multiple times to include multiple paths. \n\nThe <code>prefix=</code> query parameter may be used to define a directory (or multiple directories) where the archive's contents should be placed. If the prefix does not end with /, one will be added automatically. The prefix is <i>always</i> treated as a directory; it is not possible to use it to prepend characters to the entries in the archive. \n\nArchives of public repositories may be streamed by any authenticated or anonymous user. Streaming archives for non-public repositories requires an <i>authenticated user</i> with at least <b>REPO_READ</b> permission.", summary="Stream archive of repository")
    @Parameters(value={@Parameter(name="at", description="The commit hash or fully-qualified ref name (e.g. refs/tags/example) to stream an archive of; if not supplied, an archive of the default branch is streamed", in=ParameterIn.QUERY), @Parameter(name="filename", description="A filename to include the \"Content-Disposition\" header", in=ParameterIn.QUERY), @Parameter(name="format", description="The format to stream the archive in; must be one of: zip, tar, tar.gz or tgz", in=ParameterIn.QUERY), @Parameter(name="path", description="Paths to include in the streamed archive; may be repeated to include multiple paths", in=ParameterIn.QUERY), @Parameter(name="prefix", description="A prefix to apply to all entries in the streamed archive; if the supplied prefix does not end with a trailing /, one will be added automatically", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="An archive or the requested commit, in zip, tar or gzipped-tar format.", responseCode=200), @ResponseDoc(documentation="The requested format is not supported.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist or does not contain the at commit.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getArchive(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="at") String commitId, @QueryParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="path") List<String> paths, @QueryParam(value="prefix") String prefix) {
        Repository repository = repositoryResolver.getRepository();
        Branch ref = null;
        if (commitId == null) {
            ref = this.refService.getDefaultBranch(repository);
            commitId = ref.getLatestCommit();
        }
        ArchiveRequest request = new ArchiveRequest.Builder(repository, commitId).format(this.parseFormat(format)).paths(paths).prefix(prefix).build();
        if (filename == null) {
            if (ref == null) {
                ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(commitId).build());
            }
            filename = ArchiveResource.buildFilename(request, (Ref)ref);
        }
        String contentDisposition = ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.ATTACHMENT, (String)filename);
        return ResponseFactory.ok((headers, output) -> this.contentService.streamArchive(request, contentType -> {
            headers.putSingle((Object)"Content-Disposition", (Object)contentDisposition);
            headers.putSingle((Object)"Content-Type", (Object)contentType);
            return output;
        })).build();
    }

    private static String buildFilename(ArchiveRequest request, Ref ref) {
        StringBuilder builder = new StringBuilder(request.getRepository().getSlug()).append("-");
        if (ref == null) {
            builder.append(ArchiveResource.replaceSlashes(request.getCommitId()));
        } else {
            builder.append(ArchiveResource.replaceSlashes(ref.getDisplayId())).append('@').append(ref.getLatestCommit().substring(0, 11));
        }
        return builder.append(".").append(request.getFormat().getDefaultExtension()).toString();
    }

    private static String replaceSlashes(String value) {
        return value.replace('/', '-');
    }

    private ArchiveFormat parseFormat(String value) {
        if ((value = StringUtils.trimToNull((String)value)) == null) {
            return ArchiveFormat.ZIP;
        }
        try {
            return ArchiveFormat.fromExtension((String)value.replaceAll("[_-]", "."));
        }
        catch (IllegalArgumentException e) {
            List supportedFormats = (List)Stream.of(ArchiveFormat.values()).map(ArchiveFormat::getExtensions).flatMap(Collection::stream).collect(MoreCollectors.toImmutableList());
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.archive.unsupportedformat", new Object[]{value, supportedFormats}));
        }
    }
}

