/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.content.RestChange;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/changes")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class ChangeResource {
    private final CommitService commitService;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;

    @Inject
    public ChangeResource(I18nService i18nService, CommitService commitService, NavBuilder navBuilder) {
        this.commitService = commitService;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
    }

    @Operation(description="Retrieve a page of changes made in a specified commit. \n\n<strong>Note:</strong> The implementation will apply a hard cap ({@code page.max.changes}) and it is not possible to request subsequent content when that cap is exceeded. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get changes made in commit")
    @Parameters(value={@Parameter(name="since", description="The commit to which <code>until</code> should be compared to produce a page of changes. If not specified the commit's first parent is assumed (if one exists)", in=ParameterIn.QUERY), @Parameter(name="until", description="The commit to retrieve changes for", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of changes", paged=true, representation=RestChange.class, responseCode=200), @ResponseDoc(documentation="The until parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository or the since or until parameters supplied does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getChanges(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="since") String parentId, @QueryParam(value="until") String commitId, final @BeanParam PageRequestResolver pageRequestResolver) {
        Repository repository = repositoryResolver.getRepository();
        if (StringUtils.isBlank((CharSequence)commitId)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.until.required", new Object[0]));
        }
        final ChangesRequest request = new ChangesRequest.Builder(repository, commitId).sinceId(parentId).withComments(false).build();
        final NavBuilder.Commit commitNav = this.navBuilder.repo(repository).commit(commitId);
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                ChangeResource.this.commitService.streamChanges(request, (ChangeCallback)new JsonChangeCallback(writer, pageRequestResolver.getPageRequest(), commitNav));
            }
        }, (CacheControl)CachePolicies.getCacheControlForRange((String)commitId, (String)parentId)).build();
    }
}

