/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.ContentTreeSummary;
import com.atlassian.bitbucket.content.Directory;
import com.atlassian.bitbucket.content.EditFileRequest;
import com.atlassian.bitbucket.content.File;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.Submodule;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestBlame;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestContentTreeNode;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestDirectory;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestDirectoryRevision;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestFile;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestSubmodule;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.PageHelper;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfig;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.stash.internal.rest.content.JsonFileContentCallback;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/browse")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class ContentResource {
    private final AvatarEnricher avatarEnricher;
    private final ContentService contentService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final LinkEnricher linkEnricher;
    private final RefService refService;
    private final RepositoryService repositoryService;

    @Inject
    public ContentResource(AvatarEnricher avatarEnricher, ContentService contentService, FeatureManager featureManager, I18nService i18nService, LinkEnricher linkEnricher, RefService refService, RepositoryService repositoryService) {
        this.avatarEnricher = avatarEnricher;
        this.contentService = contentService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.linkEnricher = linkEnricher;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Retrieve a page of content for a file path at a specified revision. \n\nResponses from this endpoint vary widely depending on the query parameters. The example JSON is for a request that does not use size, type, blame or noContent. \n\n1. size will return a response like {\"size\":10000}\n2. type will return a response like {\"type\":\"FILE\"}, where possible values are    \"DIRECTORY\", \"FILE\" and \"SUBMODULE\"\n3. blame <i>without</i> noContent will include blame for the lines of    content returned on the page\n4. blame <i>with</i> noContent will omit file contents and only return    blame for the requested lines\n5. noContent without blame is ignored and does nothing\n\n\nThe various parameters are \"processed\" in the above order. That means ?size=true&amp;type=truewill return a size response, not a type one; the type parameter will be ignored. \n\nThe blame and noContent query parameters are handled differently from size and type. For blame and noContent, the <i>presence</i> of the parameter implies \"true\" if no value is specified; size and and type both require an explicit=true or they're treated as \"false\". \n\n- ?blame is the same as ?blame=true\n- ?blame&amp;noContent is the same as ?blame=true&amp;noContent=true\n- ?size is the same as ?size=false\n- ?type is the same as ?type=false\n\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get file content")
    @Parameters(value={@Parameter(name="path", description="The file path to retrieve content from", in=ParameterIn.PATH), @Parameter(name="at", description="The commit ID or ref to retrieve the content for", in=ParameterIn.QUERY), @Parameter(name="size", description="If true only the size will be returned for the file path instead of the contents", in=ParameterIn.QUERY), @Parameter(name="type", description="If true only the type will be returned for the file path instead of the contents", in=ParameterIn.QUERY), @Parameter(name="blame", description="If present and not equal to 'false', the blame will be returned for the file as well", in=ParameterIn.QUERY), @Parameter(name="noContent", description="If blame&amp;noContent only the blame is retrieved instead of the contents", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of contents from a file.", paged=true, responseCode=200), @ResponseDoc(documentation="The path or until parameters were not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getContent(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="at") @DefaultValue(value="") String at, @PathParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="size") @DefaultValue(value="false") boolean size, @QueryParam(value="type") @DefaultValue(value="false") boolean type, @QueryParam(value="blame") String blame, @QueryParam(value="noContent") String noContent, @Context ContainerRequestContext request) {
        boolean isNoContent;
        Repository repository = repositoryResolver.getRepository();
        if (StringUtils.isBlank((CharSequence)at)) {
            try {
                at = this.refService.getDefaultBranch(repository).getId();
            }
            catch (NoDefaultBranchException e) {
                if (this.repositoryService.isEmpty(repository)) {
                    return ResponseFactory.ok((Object)new RestDirectoryRevision(new RestPath(path), e.getBranchName(), new RestPage(PageUtils.createEmptyPage((PageRequest)PageHelper.createPageRequest((I18nService)this.i18nService, (UriInfo)request.getUriInfo(), (int)500))))).build();
                }
                throw e;
            }
        }
        CacheControl cacheControl = CachePolicies.getCacheControlForObjectId((String)at);
        if (size) {
            long nodeSize = this.contentService.getSize(repository, at, path).orElse(-1L);
            return ResponseFactory.ok(Collections.singletonMap("size", nodeSize), (CacheControl)cacheControl).build();
        }
        ContentTreeNode.Type nodeType = this.contentService.getType(repository, at, path);
        if (type) {
            return ResponseFactory.ok((Object)new RestContentTreeNode.RestType(nodeType), (CacheControl)cacheControl).build();
        }
        PageRequest pageRequest = PageHelper.createPageRequest((I18nService)this.i18nService, (UriInfo)request.getUriInfo(), (int)500);
        if (nodeType == ContentTreeNode.Type.DIRECTORY) {
            return ResponseFactory.ok((Object)this.getDirectory(repository, at, path, pageRequest), (CacheControl)cacheControl).build();
        }
        if (nodeType == ContentTreeNode.Type.SUBMODULE) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.rest.content.submodule.unsupported", new Object[0])).build();
        }
        boolean showBlame = blame != null && !"false".equalsIgnoreCase(blame);
        boolean bl = isNoContent = noContent != null && !"false".equalsIgnoreCase(noContent);
        if (showBlame && isNoContent) {
            Page page = this.contentService.getBlame(repository, at, path, pageRequest);
            if (request.getUriInfo().getQueryParameters().containsKey((Object)"start") || request.getUriInfo().getQueryParameters().containsKey((Object)"limit") || request.getUriInfo().getQueryParameters().containsKey((Object)"pageSize")) {
                return ResponseFactory.ok((Object)new RestPage(page, RestBlame.REST_TRANSFORM), (CacheControl)cacheControl).build();
            }
            ImmutableList pageAsList = ImmutableList.copyOf((Iterable)page.transform(RestBlame::new).getValues());
            return ResponseFactory.ok((Object)pageAsList, (CacheControl)cacheControl).build();
        }
        AvatarRequest avatarRequest = null;
        if (showBlame) {
            avatarRequest = AvatarRequestHelper.makeAvatarRequest((ContainerRequestContext)request, (I18nService)this.i18nService);
        }
        return ResponseFactory.ok((Object)this.getFile(repository, at, path, avatarRequest, pageRequest, showBlame), (CacheControl)cacheControl).build();
    }

    @Operation(description="Retrieve a page of content for a file path at a specified revision. \n\nResponses from this endpoint vary widely depending on the query parameters. The example JSON is for a request that does not use size, type, blame or noContent. \n\n1. size will return a response like {\"size\":10000}\n2. type will return a response like {\"type\":\"FILE\"}, where possible values are    \"DIRECTORY\", \"FILE\" and \"SUBMODULE\"\n3. blame <i>without</i> noContent will include blame for the lines of    content returned on the page\n4. blame <i>with</i> noContent will omit file contents and only return    blame for the requested lines\n5. noContent without blame is ignored and does nothing\n\n\nThe various parameters are \"processed\" in the above order. That means ?size=true&amp;type=truewill return a size response, not a type one; the type parameter will be ignored. \n\nThe blame and noContent query parameters are handled differently from size and type. For blame and noContent, the <i>presence</i> of the parameter implies \"true\" if no value is specified; size and and type both require an explicit=true or they're treated as \"false\". \n\n- ?blame is the same as ?blame=true\n- ?blame&amp;noContent is the same as ?blame=true&amp;noContent=true\n- ?size is the same as ?size=false\n- ?type is the same as ?type=false\n\n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get file content at revision")
    @Parameters(value={@Parameter(name="at", description="The commit ID or ref to retrieve the content for", in=ParameterIn.QUERY), @Parameter(name="size", description="If true only the size will be returned for the file path instead of the contents", in=ParameterIn.QUERY), @Parameter(name="type", description="If true only the type will be returned for the file path instead of the contents", in=ParameterIn.QUERY), @Parameter(name="blame", description="If present and not equal to 'false', the blame will be returned for the file as well", in=ParameterIn.QUERY), @Parameter(name="noContent", description="If blame&amp;noContent only the blame is retrieved instead of the contents", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of contents from a file.", paged=true, responseCode=200), @ResponseDoc(documentation="The path parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getContent(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="at") @DefaultValue(value="") String objectId, @QueryParam(value="size") @DefaultValue(value="false") boolean size, @QueryParam(value="type") @DefaultValue(value="false") boolean type, @QueryParam(value="blame") String withBlame, @QueryParam(value="noContent") String noContent, @Context ContainerRequestContext request) {
        return this.getContent(repositoryResolver, objectId, "", size, type, withBlame, noContent, request);
    }

    @Operation(description="Update the content of path, on the given repository and branch. \n\nThis resource accepts PUT multipart form data, containing the file in a form-field named content. \n\nAn example <a href=\"http://curl.haxx.se/\">curl</a> request to update 'README.md' would be:\n\n```curl -X PUT -u username:password -F content=@README.md  -F 'message=Updated using file-edit REST API' -F branch=master -F  sourceCommitId=5636641a50b  http://example.com/rest/api/latest/projects/PROJECT_1/repos/repo_1/browse/README.md ```\n\n- branch:  the branch on which the path should be modified or created\n- content: the full content of the file at path \n- message: the message associated with this change, to be used as the commit message. Or null if the default message should be used.\n- sourceCommitId: the commit ID of the file before it was edited, used to identify if content has changed. Or null if this is a new file\n\n\nThe file can be updated or created on a new branch. In this case, the sourceBranch parameter should be provided to identify the starting point for the new branch and the branch parameter identifies the branch to create the new commit on.", summary="Edit file")
    @Parameters(value={@Parameter(name="path", description="The path of the file that is to be modified or created", in=ParameterIn.PATH)})
    @RequestBody(description="The multipart form data containing the file", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExampleMultipartFormData.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created commit.", representation=RestCommit.class, responseCode=200), @ResponseDoc(documentation="There are validation errors, e.g. The branch or content parameters were not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user does not have write permission for the given repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The request was authenticated using a project or repository access token, which does not have a valid user associated with it", responseCode=403, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The file already exists when trying to create a file, or the given content does not modify the file, or the file has changed since the given sourceCommitId, or the repository is archived.", responseCode=409, restError=true)})
    @PUT
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=EditFileMultipartConfig.class)
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response editFile(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="path") String path, @MultipartFormParam(value="branch") FilePart branch, @MultipartFormParam(value="content") FilePart content, @MultipartFormParam(value="message") FilePart message, @MultipartFormParam(value="sourceBranch") FilePart sourceBranch, @MultipartFormParam(value="sourceCommitId") FilePart sourceCommitId, @Context ContainerRequestContext request) {
        String branchName;
        Repository repository = repositoryResolver.getRepository();
        if (!this.featureManager.isEnabled((Feature)StandardFeature.FILE_EDITOR)) {
            throw new FileEditorDisabledException(this.i18nService.createKeyedMessage("bitbucket.rest.content.update.fileeditordisabled", new Object[0]));
        }
        String string = branchName = branch == null ? null : this.readFilePart(branch, "branch");
        if (StringUtils.isEmpty((CharSequence)branchName)) {
            try {
                branchName = this.refService.getDefaultBranch(repository).getDisplayId();
            }
            catch (NoDefaultBranchException e) {
                branchName = e.getBranchName();
            }
        }
        if (content == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.content.update.badrequest.content", new Object[0]));
        }
        EditFileRequest.Builder editFileRequestBuilder = new EditFileRequest.Builder(branchName, path, repository).content(() -> ((FilePart)content).getInputStream());
        if (sourceBranch != null) {
            editFileRequestBuilder.sourceBranch(this.readFilePart(sourceBranch, "sourceBranch"));
        }
        if (sourceCommitId != null) {
            editFileRequestBuilder.sourceCommitId(sourceCommitId.getValue());
        }
        if (message != null) {
            editFileRequestBuilder.message(this.readFilePart(message, "message"));
        }
        Commit newCommit = this.contentService.editFile(editFileRequestBuilder.build());
        return ResponseFactory.ok((Object)new RestCommit(newCommit)).build();
    }

    private RestDirectoryRevision getDirectory(Repository repository, String commitId, String path, PageRequest pageRequest) {
        final ArrayList nodes = Lists.newArrayList();
        final ContentTreeSummary[] summaryRef = new ContentTreeSummary[1];
        this.contentService.streamDirectory(repository, commitId, path, false, (ContentTreeCallback)new AbstractContentTreeCallback(this){

            public void onEnd(@Nonnull ContentTreeSummary summary) {
                summaryRef[0] = summary;
            }

            public boolean onTreeNode(@Nonnull ContentTreeNode node) {
                if (node.getType() == ContentTreeNode.Type.DIRECTORY) {
                    nodes.add(new RestDirectory((Directory)node));
                } else if (node.getType() == ContentTreeNode.Type.SUBMODULE) {
                    nodes.add(new RestSubmodule((Submodule)node));
                } else {
                    nodes.add(new RestFile((File)node));
                }
                return true;
            }
        }, pageRequest);
        ContentTreeSummary summary = summaryRef[0];
        return new RestDirectoryRevision(new RestPath(path), commitId, new RestPage(summary.getPageRequest().getStart(), summary.getPageRequest().getLimit(), summary.getSize(), summary.isLastPage(), (Iterable)nodes, summary.getNextPageRequest()));
    }

    private StreamingOutput getFile(final Repository repository, final String objectId, final String path, AvatarRequest avatarRequest, final PageRequest pageRequest, final boolean withBlame) {
        final Function<Blame, RestBlame> transformer = this.getBlameTransformer(withBlame, avatarRequest);
        return new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) {
                ContentResource.this.contentService.streamFile(repository, objectId, path, pageRequest, withBlame, (FileContentCallback)new JsonFileContentCallback(writer, new RestPath(path), transformer));
            }
        };
    }

    private Function<Blame, RestBlame> getBlameTransformer(boolean withBlame, AvatarRequest avatarRequest) {
        if (!withBlame) {
            return null;
        }
        Function<Blame, RestBlame> transformer = RestBlame.REST_TRANSFORM.andThen(blame -> {
            this.linkEnricher.enrich(blame);
            return blame;
        });
        if (avatarRequest != null) {
            transformer = transformer.andThen(blame -> {
                this.avatarEnricher.enrich(blame, avatarRequest);
                return blame;
            });
        }
        return transformer;
    }

    private String readFilePart(FilePart part, String parameter) {
        String string;
        block8: {
            InputStream stream = part.getInputStream();
            try {
                string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.content.update.badrequest.badstream", new Object[]{parameter}));
                }
            }
            stream.close();
        }
        return string;
    }

    public static class FileEditorDisabledException
    extends FeatureDisabledException {
        FileEditorDisabledException(@Nonnull KeyedMessage message) {
            super(message);
        }
    }

    private static class ExampleMultipartFormData {
        private ExampleMultipartFormData() {
        }

        @Schema(description="The branch on which the <code>path</code> should be modified or created.")
        public String getBranch() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The full content of the file at <code>path</code>.")
        public String getContent() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The message associated with this change, to be used as the commit message. Or null if the default message should be used.")
        public String getMessage() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The starting point for <code>branch</code>. If provided and different from <code>branch</code>, <code>branch</code> will be created as a new branch, branching off from <code>sourceBranch</code>.")
        public String getSourceBranch() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The commit ID of the file before it was edited, used to identify if content has changed. Or null if this is a new file")
        public String getSourceCommitId() {
            throw new RuntimeException("This method should not be invoked");
        }
    }

    public static class EditFileMultipartConfig
    implements MultipartConfig {
        ContentService contentService = (ContentService)ComponentLocator.getComponent(ContentService.class);

        public long getMaxFileSize() {
            return this.contentService.getMaxUploadSize();
        }

        public long getMaxSize() {
            return -1L;
        }
    }
}

