/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.rest.content.RestContentHelper;
import com.atlassian.stash.internal.rest.content.StandardFile;
import com.atlassian.stash.internal.rest.util.BoundedByteArrayOutputStream;
import com.atlassian.stash.internal.rest.util.ByteLimitExceededException;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class DefaultRestContentHelper
implements RestContentHelper {
    static final String MAX_RAW_CONTENT_SIZE = "plugin.rest.raw.content.markup.max.size";
    private final ContentService contentService;
    private final I18nService i18nService;
    private final MarkupService markupService;
    private final int maxSize;
    private final RefService refService;
    private final RepositoryService repositoryService;

    public DefaultRestContentHelper(ContentService contentService, I18nService i18nService, MarkupService markupService, ApplicationPropertiesService propertiesService, RefService refService, RepositoryService repositoryService) {
        this.contentService = contentService;
        this.i18nService = i18nService;
        this.markupService = markupService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.maxSize = propertiesService.getPluginProperty(MAX_RAW_CONTENT_SIZE, 0x500000);
    }

    @Override
    @Nonnull
    public String getRevision(@Nonnull Repository repository, @Nullable String revision, @Nonnull String path) {
        if (StringUtils.isBlank((CharSequence)revision)) {
            return this.getDefaultBranch(repository, path);
        }
        return revision;
    }

    @Override
    @Nonnull
    public String searchFiles(@Nonnull Repository repository, @Nonnull String commitId, final @Nonnull StandardFile file) {
        final MutableObject matched = new MutableObject();
        this.contentService.streamDirectory(repository, commitId, "", false, (ContentTreeCallback)new AbstractContentTreeCallback(this){

            public boolean onTreeNode(@Nonnull ContentTreeNode node) {
                String filename;
                if (node.getType() == ContentTreeNode.Type.FILE && file.matches(filename = node.getPath().getName())) {
                    matched.setValue((Object)filename);
                    return false;
                }
                return true;
            }
        }, PageUtils.newRequest((int)0, (int)1000));
        String path = (String)matched.getValue();
        if (path == null) {
            throw this.newNoSuchPathException(file.getName(), commitId);
        }
        return path;
    }

    @Override
    @Nonnull
    public Response.ResponseBuilder streamBytes(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String path) {
        return ResponseFactory.ok((headers, outputStream) -> {
            this.contentService.streamFile(repository, commitId, path, contentType -> {
                if (StringUtils.startsWith((CharSequence)contentType, (CharSequence)"text/")) {
                    contentType = (String)contentType + ";charset=UTF-8";
                }
                String filename = path.contains("/") ? StringUtils.substringAfterLast((String)path, (String)"/") : path;
                headers.putSingle((Object)"Content-Disposition", (Object)ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.ATTACHMENT, (String)filename));
                headers.putSingle((Object)"Content-Type", contentType);
                return outputStream;
            });
            outputStream.flush();
        });
    }

    @Override
    @Nonnull
    public Response.ResponseBuilder streamMarkup(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String path, @Nonnull RenderContext renderContext) {
        BoundedByteArrayOutputStream rawStream = new BoundedByteArrayOutputStream(512, this.maxSize);
        int status = 200;
        MutableObject contentTypeHeader = new MutableObject();
        try {
            this.contentService.streamFile(repository, commitId, path, contentType -> {
                contentTypeHeader.setValue((Object)contentType);
                return rawStream;
            });
        }
        catch (ServiceException e) {
            status = Throwables.getCausalChain((Throwable)e).stream().filter(ByteLimitExceededException.class::isInstance).findFirst().map(ignored -> 206).orElseThrow(() -> e);
        }
        byte[] bytes = rawStream.toByteArray();
        return ResponseFactory.status((int)status).entity((headers, outputStream) -> {
            if (ContentDetectionUtils.isBinary((byte[])bytes)) {
                headers.putSingle((Object)"Content-Type", contentTypeHeader.getValue());
                outputStream.write(bytes);
            } else {
                headers.putSingle((Object)"Content-Type", (Object)"text/html;charset=UTF-8");
                try (Reader reader = DefaultRestContentHelper.createReader(bytes);
                     OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    this.markupService.stream(reader, (Appendable)writer, renderContext);
                }
            }
            outputStream.flush();
        });
    }

    private static Reader createReader(byte[] bytes) {
        String detectedEncoding = ContentDetectionUtils.detectEncoding((byte[])bytes);
        return new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), detectedEncoding == null ? StandardCharsets.UTF_8 : Charset.forName(detectedEncoding));
    }

    private String getDefaultBranch(@Nonnull Repository repository, @Nonnull String path) {
        try {
            return this.refService.getDefaultBranch(repository).getId();
        }
        catch (NoDefaultBranchException e) {
            if (this.repositoryService.isEmpty(repository)) {
                throw this.newNoSuchPathException(path, e.getBranchName());
            }
            throw e;
        }
    }

    private NoSuchPathException newNoSuchPathException(String path, String at) {
        throw new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.service.repository.pathnotfound.atrevision", new Object[]{path, at}), path, at);
    }
}

