/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiff;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/diff")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class DiffResource {
    private final CommitService commitService;
    private final I18nService i18nService;

    @Inject
    public DiffResource(I18nService i18nService, CommitService commitService) {
        this.commitService = commitService;
        this.i18nService = i18nService;
    }

    @Operation(description="Retrieve the diff for a specified file path between two provided revisions. \n\n<strong>Note:</strong> This resource is currently <i>not paged</i>. The server will internally apply a hard cap to the streamed lines, and it is not possible to request subsequent pages if that cap is exceeded. In the event that the cap is reached, the diff will be cut short and one or more <code>truncated</code> flags will be set to <code>true</code> on the segments, hunks and diffs substructures in the returned JSON response. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", hidden=true)
    @Parameters(value={@Parameter(name="path", description="The path to the file which should be diffed (required)", in=ParameterIn.PATH), @Parameter(name="contextLines", description="The number of context lines to include around added/removed lines in the diff", in=ParameterIn.QUERY), @Parameter(name="since", description="The base revision to diff from. If omitted the parent revision of the until revision is used", in=ParameterIn.QUERY), @Parameter(name="srcPath", description="The source path for the file, if it was copied, moved or renamed", in=ParameterIn.QUERY), @Parameter(name="until", description="The target revision to diff to (required)", in=ParameterIn.QUERY), @Parameter(name="whitespace", description="Optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A diff of a file path.", representation=RestDiff.class, responseCode=200), @ResponseDoc(documentation="The path or until parameters were not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="path") String path, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="until") String untilId, @QueryParam(value="whitespace") String whitespace) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.diff.path.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)untilId)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.diff.until.required", new Object[0]));
        }
        final DiffRequest.Builder builder = new DiffRequest.Builder(repositoryResolver.getRepository(), untilId).contextLines(contextLines).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace)).withComments(false);
        if (StringUtils.isNotBlank((CharSequence)srcPath)) {
            builder.path(srcPath);
        }
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                DiffResource.this.commitService.streamDiff(builder.build(), (DiffContentCallback)new JsonDiffContentCallback(writer, RestComment.REST_TRANSFORM));
            }
        }, (CacheControl)CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId)).build();
    }

    @Operation(hidden=true)
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamDiff(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="until") String untilId, @QueryParam(value="whitespace") String whitespace) {
        return this.streamDiff(repositoryResolver, null, contextLines, sinceId, srcPath, untilId, whitespace);
    }

    @Operation(description="Stream the raw diff between two provided revisions. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get raw diff for path")
    @Parameters(value={@Parameter(name="path", description="The path to the file which should be diffed (required)", in=ParameterIn.PATH), @Parameter(name="contextLines", description="The number of context lines to include around added/removed lines in the diff", in=ParameterIn.QUERY), @Parameter(name="since", description="The base revision to diff from. If omitted the parent revision of the until revision is used", in=ParameterIn.QUERY), @Parameter(name="srcPath", description="The source path for the file, if it was copied, moved or renamed", in=ParameterIn.QUERY), @Parameter(name="until", description="The target revision to diff to (required)", in=ParameterIn.QUERY), @Parameter(name="whitespace", description="Optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A raw diff between two revisions.", responseCode=200), @ResponseDoc(documentation="The until parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{path:.*}")
    @Produces(value={"text/plain; qs=0.1"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @PathParam(value="path") String path, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="until") String untilId, @QueryParam(value="whitespace") String whitespace) {
        if (StringUtils.isBlank((CharSequence)untilId)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.diff.until.required", new Object[0]));
        }
        DiffRequest.Builder builder = new DiffRequest.Builder(repositoryResolver.getRepository(), untilId).contextLines(contextLines).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace));
        if (StringUtils.isNotBlank((CharSequence)srcPath)) {
            builder.path(srcPath);
        }
        return ResponseFactory.ok((headers, output) -> this.commitService.streamDiff(builder.build(), contentType -> {
            headers.putSingle((Object)"Content-Type", (Object)contentType);
            return output;
        }), (CacheControl)CachePolicies.getCacheControlForRange((String)untilId, (String)sinceId)).build();
    }

    @Operation(description="Stream the raw diff between two provided revisions. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get raw diff for path")
    @Parameters(value={@Parameter(name="contextLines", description="The number of context lines to include around added/removed lines in the diff", in=ParameterIn.QUERY), @Parameter(name="since", description="The base revision to diff from. If omitted the parent revision of the until revision is used", in=ParameterIn.QUERY), @Parameter(name="srcPath", description="The source path for the file, if it was copied, moved or renamed", in=ParameterIn.QUERY), @Parameter(name="until", description="The target revision to diff to (required)", in=ParameterIn.QUERY), @Parameter(name="whitespace", description="Optional whitespace flag which can be set to <code>ignore-all</code>", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A raw diff between two revisions.", responseCode=200), @ResponseDoc(documentation="The path parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Produces(value={"text/plain; qs=0.1"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRawDiff(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="until") String untilId, @QueryParam(value="whitespace") String whitespace) {
        return this.streamRawDiff(repositoryResolver, contextLines, null, sinceId, srcPath, untilId, whitespace);
    }
}

