/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.JsonContentTreeCallback;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/files")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class FileListResource {
    private final ContentService contentService;
    private final I18nService i18nService;
    private final RefService refService;
    private final RepositoryService repositoryService;

    @Inject
    public FileListResource(ContentService contentService, I18nService i18nService, RefService refService, RepositoryService repositoryService) {
        this.contentService = contentService;
        this.i18nService = i18nService;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    @Operation(description="Retrieve a page of files from particular directory of a repository. The search is done recursively, so all files from any sub-directory of the specified directory will be returned. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get files in directory")
    @Parameters(value={@Parameter(name="path", description="The directory to list files for.", in=ParameterIn.PATH), @Parameter(name="at", description="The commit ID or ref (e.g. a branch or tag) to list the files at. If not specified the default branch will be used instead.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of files.", paged=true, representation=FileListResource.class, responseCode=200), @ResponseDoc(documentation="The path requested is not a directory at the supplied commit.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The path requested does not exist at the supplied commit.", responseCode=404, restError=true)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamFiles(final @BeanParam RepositoryResolver repositoryResolver, final @PathParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="at") String at, final @BeanParam PageRequestResolver pageRequestResolver) {
        String objectId;
        boolean useDefault = StringUtils.isBlank((CharSequence)at);
        if (useDefault && this.repositoryService.isEmpty(repositoryResolver.getRepository())) {
            return ResponseFactory.ok((Object)new RestPage(PageUtils.createEmptyPage((PageRequest)pageRequestResolver.getPageRequest()))).build();
        }
        String string = objectId = useDefault ? this.refService.getDefaultBranch(repositoryResolver.getRepository()).getId() : at;
        if (this.contentService.getType(repositoryResolver.getRepository(), objectId, path) != ContentTreeNode.Type.DIRECTORY) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.filelist.not.directory", new Object[]{path, objectId}));
        }
        return ResponseFactory.ok((Object)new JsonStreamingOutput(){

            public void write(StatefulJsonWriter writer) {
                FileListResource.this.contentService.streamDirectory(repositoryResolver.getRepository(), objectId, path, true, (ContentTreeCallback)new JsonContentTreeCallback(writer), pageRequestResolver.getPageRequest());
            }
        }, (CacheControl)CachePolicies.getCacheControlForObjectId((String)at)).build();
    }

    @Operation(description="Retrieve a page of files from particular directory of a repository. The search is done recursively, so all files from any sub-directory of the specified directory will be returned. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get files in directory")
    @Parameters(value={@Parameter(name="at", description="The commit ID or ref (e.g. a branch or tag) to list the files at. If not specified the default branch will be used instead.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of files.", paged=true, representation=FileListResource.class, responseCode=200), @ResponseDoc(documentation="The path parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The path requested does not exist at the supplied commit.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamFiles(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="at") String at, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.streamFiles(repositoryResolver, "", at, pageRequestResolver);
    }
}

