/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.content.RestChange;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import java.io.IOException;

public class JsonChangeCallback
implements ChangeCallback {
    private final NavBuilder.Commit commitNav;
    private final PageRequest pageRequest;
    private final StatefulJsonWriter writer;
    private boolean ended;
    private int received;
    private int written;

    public JsonChangeCallback(StatefulJsonWriter writer, PageRequest pageRequest) {
        this(writer, pageRequest, null);
    }

    public JsonChangeCallback(StatefulJsonWriter writer, PageRequest pageRequest, NavBuilder.Commit commitNav) {
        this.commitNav = commitNav;
        this.pageRequest = pageRequest;
        this.writer = writer;
    }

    public boolean onChange(@Nonnull Change change) throws IOException {
        if (this.received++ < this.pageRequest.getStart()) {
            return true;
        }
        if (this.written == this.pageRequest.getLimit()) {
            this.endPage(false);
            return false;
        }
        this.writer.value((Object)new RestChange(change, this.commitNav));
        ++this.written;
        return true;
    }

    public void onEnd(@Nonnull ChangeSummary summary) throws IOException {
        this.endPage(!summary.isTruncated());
    }

    public void onStart(@Nonnull ChangeContext context) throws IOException {
        this.writer.beginObject().name("fromHash").value(context.getFromHash()).name("toHash").value(context.getToHash()).name("properties").value((Object)context.getProperties()).name("values").beginArray();
    }

    private void endPage(boolean lastPage) throws IOException {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.writer.endArray().name("size").value((long)this.written).name("isLastPage").value(lastPage).name("start").value((long)this.pageRequest.getStart()).name("limit").value((long)this.pageRequest.getLimit()).name("nextPageStart");
        if (lastPage || this.pageRequest.getLimit() > this.written) {
            this.writer.nullValue();
        } else {
            this.writer.value((long)(this.pageRequest.getStart() + this.pageRequest.getLimit()));
        }
        this.writer.endObject();
    }
}

