/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.content.AbstractContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeContext;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.ContentTreeSummary;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import java.io.IOException;

public class JsonContentTreeCallback
extends AbstractContentTreeCallback {
    private final StatefulJsonWriter writer;

    public JsonContentTreeCallback(StatefulJsonWriter writer) {
        this.writer = writer;
    }

    public void onEnd(@Nonnull ContentTreeSummary summary) throws IOException {
        PageRequest current = summary.getPageRequest();
        PageRequest next = summary.getNextPageRequest();
        this.writer.endArray().name("size").value((long)summary.getSize()).name("isLastPage").value(summary.isLastPage()).name("start").value((long)current.getStart()).name("limit").value((long)current.getLimit()).name("nextPageStart");
        if (next == null) {
            this.writer.nullValue();
        } else {
            this.writer.value((long)next.getStart());
        }
        this.writer.endObject();
    }

    public void onStart(@Nonnull ContentTreeContext context) throws IOException {
        this.writer.beginObject().name("values").beginArray();
    }

    public boolean onTreeNode(@Nonnull ContentTreeNode node) throws IOException {
        if (node.getType() == ContentTreeNode.Type.FILE) {
            this.writer.value(node.getPath().toString());
        }
        return true;
    }
}

