/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonDiffContentCallback
extends AbstractDiffContentCallback {
    private final Function<Comment, RestComment> commentTransformer;
    private final List<Comment> fileComments;
    private final List<Comment> lineComments;
    private final Map<DiffSegmentType, Map<Integer, List<CommentThread>>> threadsByLineType;
    private final StatefulJsonWriter writer;
    private int currentDestinationLine;
    private Map<Integer, List<CommentThread>> currentSegmentThreads;
    private DiffSegmentType currentSegmentType;
    private int currentSourceLine;

    public JsonDiffContentCallback(StatefulJsonWriter writer, Function<Comment, RestComment> commentTransformer) {
        this.commentTransformer = commentTransformer;
        this.writer = writer;
        this.fileComments = new ArrayList<Comment>();
        this.lineComments = new ArrayList<Comment>();
        this.threadsByLineType = new EnumMap<DiffSegmentType, Map<Integer, List<CommentThread>>>(DiffSegmentType.class);
    }

    public void offerThreads(@Nonnull Stream<CommentThread> threads) throws IOException {
        threads.forEach(thread -> thread.getAnchor().ifPresent(anchor -> {
            if (anchor.isFileAnchor()) {
                this.fileComments.add(thread.getRootComment());
            } else {
                this.threadsByLineType.computeIfAbsent((DiffSegmentType)anchor.getLineType().get(), lineType -> new HashMap()).computeIfAbsent(anchor.getLine(), line -> new ArrayList()).add(thread);
                this.lineComments.add(thread.getRootComment());
            }
        }));
    }

    public void onBinary(Path src, Path dst) throws IOException {
        this.startDiff(src, dst);
        this.writer.name("binary").value(true);
        this.writeComments("fileComments", this.fileComments);
        this.writer.endObject();
    }

    public void onDiffEnd(boolean truncated) throws IOException {
        this.writer.endArray();
        this.writer.name("truncated").value(truncated);
        this.writeComments("fileComments", this.fileComments);
        this.writeComments("lineComments", this.lineComments);
        this.writer.endObject();
    }

    public void onDiffStart(Path src, Path dst) throws IOException {
        this.startDiff(src, dst);
        this.writer.name("hunks");
        this.writer.beginArray();
    }

    public void onEnd(@Nonnull DiffSummary summary) throws IOException {
        this.writer.endArray().name("truncated").value(summary.isTruncated()).endObject();
    }

    public void onHunkEnd(boolean truncated) throws IOException {
        this.writer.endArray();
        this.writer.name("truncated").value(truncated);
        this.writer.endObject();
    }

    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan, String context) throws IOException {
        this.currentSourceLine = srcLine;
        this.currentDestinationLine = dstLine;
        this.writer.beginObject();
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            this.writer.name("context").value(context);
        }
        this.writer.name("sourceLine").value((long)srcLine);
        this.writer.name("sourceSpan").value((long)srcSpan);
        this.writer.name("destinationLine").value((long)dstLine);
        this.writer.name("destinationSpan").value((long)dstSpan);
        this.writer.name("segments");
        this.writer.beginArray();
    }

    public void onSegmentEnd(boolean truncated) throws IOException {
        this.currentSegmentThreads = null;
        this.currentSegmentType = null;
        this.writer.endArray();
        this.writer.name("truncated").value(truncated);
        this.writer.endObject();
    }

    public void onSegmentLine(@Nonnull String line, ConflictMarker marker, boolean truncated) throws IOException {
        int sourceLine = this.currentSourceLine;
        int destinationLine = this.currentDestinationLine;
        int commentLine = this.chooseCommentLineAndIncrementLines();
        this.writer.beginObject();
        this.writer.name("source").value((long)sourceLine);
        this.writer.name("destination").value((long)destinationLine);
        this.writer.name("line").value(line);
        this.writer.name("truncated").value(truncated);
        if (marker != null) {
            this.writer.name("conflictMarker").value((Object)marker);
        }
        if (this.currentSegmentThreads != null && this.currentSegmentThreads.containsKey(commentLine)) {
            List<CommentThread> threads = this.currentSegmentThreads.get(commentLine);
            this.writer.name("commentIds");
            this.writer.beginArray();
            for (CommentThread thread : threads) {
                this.writer.value(thread.getRootComment().getId());
            }
            this.writer.endArray();
        }
        this.writer.endObject();
    }

    public void onSegmentStart(@Nonnull DiffSegmentType type) throws IOException {
        this.currentSegmentThreads = this.threadsByLineType.get(type);
        this.currentSegmentType = type;
        this.writer.beginObject();
        this.writer.name("type").value(type.name());
        this.writer.name("lines");
        this.writer.beginArray();
    }

    public void onStart(@Nonnull DiffContext context) throws IOException {
        this.writer.beginObject().name("fromHash").value(context.getFromHash()).name("toHash").value(context.getToHash()).name("contextLines").value((long)context.getContextLines()).name("whitespace").value(context.getWhitespace().name()).name("diffs").beginArray();
    }

    private int chooseCommentLineAndIncrementLines() {
        switch (this.currentSegmentType) {
            case ADDED: {
                return this.currentDestinationLine++;
            }
            case CONTEXT: {
                ++this.currentDestinationLine;
            }
        }
        return this.currentSourceLine++;
    }

    private void startDiff(Path src, Path dst) throws IOException {
        this.writer.beginObject();
        this.writePath("source", src);
        this.writePath("destination", dst);
    }

    private void writeComments(String name, List<Comment> comments) throws IOException {
        if (CollectionUtils.isNotEmpty(comments)) {
            this.writer.name(name);
            this.writer.beginArray();
            for (Comment comment : comments) {
                this.writer.value((Object)this.commentTransformer.apply(comment));
            }
            this.writer.endArray();
        }
    }

    private void writePath(String name, Path path) throws IOException {
        this.writer.name(name);
        if (path == null) {
            this.writer.nullValue();
        } else {
            this.writer.value((Object)new RestPath(path));
        }
    }
}

