/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.PatchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/patch")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"text/plain"})
@Singleton
@Tag(name="Repository")
public class PatchResource {
    private final ContentService contentService;
    private final I18nService i18nService;

    @Inject
    public PatchResource(ContentService contentService, I18nService i18nService) {
        this.contentService = contentService;
        this.i18nService = i18nService;
    }

    @Operation(description="Retrieve the patch content for a repository at a specified revision. \n\nCache headers are added to the response (only if full commit hashes are used, not in the case of short hashes). \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get patch content at revision")
    @Parameters(value={@Parameter(name="allAncestors", description="indicates whether or not to generate a patch which includes all the ancestors of the 'until' revision. If true, the value provided by 'since' is ignored.", in=ParameterIn.QUERY), @Parameter(name="since", description="The base revision from which to generate the patch. This is only applicable when 'allAncestors' is false. If omitted the patch will represent one single commit, the 'until'.", in=ParameterIn.QUERY), @Parameter(name="until", description="The target revision from which to generate the patch (required)", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The patch contents from a repository.", paged=true, responseCode=200), @ResponseDoc(documentation="The until parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamPatch(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="allAncestors") boolean allAncestors, @QueryParam(value="since") String since, @QueryParam(value="until") String until) {
        if (StringUtils.isBlank((CharSequence)until)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.patch.until.required", new Object[0]));
        }
        if (allAncestors && StringUtils.isNotBlank((CharSequence)since)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.patch.parameters.invalidcombination", new Object[0]));
        }
        PatchRequest request = new PatchRequest.Builder(repositoryResolver.getRepository(), until).allAncestors(allAncestors).sinceId(since).build();
        return ResponseFactory.ok((headers, output) -> this.contentService.streamPatch(request, contentType -> {
            headers.putSingle((Object)"Content-Type", (Object)contentType);
            return output;
        }), (CacheControl)CachePolicies.getCacheControlForRange((String)until, (String)since)).build();
    }
}

