/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.enrich.MarkupRequestHelper;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.content.RestContentHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/raw")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Singleton
@Tag(name="Repository")
public class RawContentResource {
    private final RestContentHelper contentHelper;
    private final I18nService i18nService;

    @Inject
    public RawContentResource(RestContentHelper contentHelper, I18nService i18nService) {
        this.contentHelper = contentHelper;
        this.i18nService = i18nService;
    }

    @Operation(description="Retrieve the raw content for a file path at a specified revision. \n\nThe authenticated user must have <strong>REPO_READ</strong> permission for the specified repository to call this resource.", summary="Get raw content of a file at revision")
    @Parameters(value={@Parameter(name="path", description="The file path to retrieve content from", in=ParameterIn.PATH), @Parameter(name="at", description="A specific commit or ref to retrieve the raw content at, or the default branch if not specified", in=ParameterIn.QUERY), @Parameter(name="hardwrap", description="(Optional) Whether the markup implementation should convert newlines to breaks. If not specified, the value of the markup.render.hardwrap property, which is true by default, will be used", in=ParameterIn.QUERY), @Parameter(name="htmlEscape", description="(Optional) true if HTML should be escaped in the input markup, false otherwise. If not specified, the value of the markup.render.html.escape property, which is true by default, will be used", in=ParameterIn.QUERY), @Parameter(name="includeHeadingId", description="(Optional) true if headings should contain an ID based on the heading content. If not specified, the value of the markup.render.headerids property, which is false by default, will be used", in=ParameterIn.QUERY), @Parameter(name="markup", description="If present or \"true\", triggers the raw content to be markup-rendered and returned as HTML; otherwise, if not specified, or any value other than \"true\", the content is streamed without markup", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The raw contents from a file.", paged=true, responseCode=200), @ResponseDoc(documentation="The path parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{path:.*}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRaw(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="at") String at, @QueryParam(value="hardwrap") String hardwrap, @QueryParam(value="htmlEscape") String htmlEscape, @QueryParam(value="includeHeadingId") String includeHeadingId, @QueryParam(value="markup") String markup) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.path.required", new Object[0]));
        }
        at = this.contentHelper.getRevision(repositoryResolver.getRepository(), (String)uriInfo.getQueryParameters().getFirst((Object)"at"), path);
        return this.streamFile(repositoryResolver.getRepository(), uriInfo, at, path).build();
    }

    @Operation(hidden=true)
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response streamRaw(@BeanParam RepositoryResolver repositoryResolver, @Context UriInfo uriInfo) {
        return this.streamRaw(repositoryResolver, uriInfo, "", "", "", "", "", "");
    }

    private Response.ResponseBuilder streamFile(Repository repository, UriInfo uriInfo, String at, String path) {
        String markup = (String)uriInfo.getQueryParameters().getFirst((Object)"markup");
        if ("".equals(markup) || "true".equalsIgnoreCase(markup)) {
            return this.contentHelper.streamMarkup(repository, at, path, MarkupRequestHelper.makeRenderContext(uriInfo));
        }
        return this.contentHelper.streamBytes(repository, at, path);
    }
}

