/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import jakarta.annotation.Nonnull;
import java.util.regex.Pattern;

public enum StandardFile {
    CONTRIBUTING_GUIDELINES("CONTRIBUTING"),
    LICENSE("LICENSE", "licen[cs]e"),
    README("README");

    private final String name;
    private final Pattern pattern;

    private StandardFile(String name) {
        this(name, name);
    }

    private StandardFile(String name, String regex) {
        this.name = name;
        this.pattern = Pattern.compile(regex + "(?:\\.(?:md|markdown|mdown|mkdn|mkd|txt|text))?$", 2);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean matches(@Nonnull String filename) {
        return this.pattern.matcher(filename).matches();
    }
}

