/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.dashboard;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dashboard.DashboardService;
import com.atlassian.bitbucket.dashboard.SuggestPullRequestsRequest;
import com.atlassian.bitbucket.dmz.rest.v2.dashboard.RestPullRequestSuggestion;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="dashboard")
@Singleton
@Tag(name="Dashboard")
public class DashboardResource {
    private static final List<PullRequestOrder> DEFAULT_ORDER = ImmutableList.of((Object)PullRequestOrder.NEWEST);
    private final AuthenticationContext authenticationContext;
    private final DashboardService dashboardService;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestService pullRequestService;
    private final UserService userService;

    @Inject
    public DashboardResource(AuthenticationContext authenticationContext, DashboardService dashboardService, I18nService i18nService, PermissionValidationService permissionValidationService, PullRequestService pullRequestService, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.dashboardService = dashboardService;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestService = pullRequestService;
        this.userService = userService;
    }

    @Operation(description="Retrieve a page of pull requests where a user is involved as either a reviewer, author or a participant. The request may be filtered by pull request state, role or participant status.", summary="Get pull requests for a user")
    @Parameters(value={@Parameter(description="(optional, defaults to returning pull requests in any state). If a state is supplied only pull requests in the specified state will be returned. Either <strong>OPEN</strong>, <strong>DECLINED</strong> or <strong>MERGED</strong>. Omit this parameter to return pull request in any state.", in=ParameterIn.QUERY, name="state"), @Parameter(description="(optional, defaults to returning pull requests for any role). If a role is supplied only pull requests where the authenticated user is a participant in the given role will be returned. Either <strong>REVIEWER</strong>, <strong>AUTHOR</strong> or <strong>PARTICIPANT</strong>.", in=ParameterIn.QUERY, name="role"), @Parameter(description="(optional, defaults to returning pull requests with any participant status). A comma separated list of participant status. That is, one or more of <strong>UNAPPROVED</strong>, <strong>NEEDS_WORK</strong>, or <strong>APPROVED</strong>.", in=ParameterIn.QUERY, name="participantStatus"), @Parameter(description="(optional, defaults to <strong>NEWEST</strong>) the order/(s) to return pull requests in; can choose from <strong>OLDEST</strong> (as in: \"oldest first\"), <strong>NEWEST</strong>, <strong>DRAFT_STATUS</strong>, <strong>PARTICIPANT_STATUS</strong>, and/or <strong>CLOSED_DATE</strong>. Where <strong>CLOSED_DATE</strong> is specified and the result set includes pull requests that are not in the closed state, these pull requests will appear first in the result set, followed by most recently closed pull requests.", in=ParameterIn.QUERY, name="order"), @Parameter(description="(optional, defaults to returning pull requests regardless of closed since date). Permits returning only pull requests with a closed timestamp set more recently that (now - closedSince). Units are in seconds. So for example if closed since 86400 is set only pull requests closed in the previous 24 hours will be returned.", in=ParameterIn.QUERY, name="closedSince"), @Parameter(description="The name of the involved user, defaults to the current user.", in=ParameterIn.QUERY, name="user")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of pull requests that match the search criteria.", paged=true, representation=RestPullRequest.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400), @ResponseDoc(documentation="The current user is not authenticated", restError=true, responseCode=401)})
    @GET
    @Path(value="pull-requests")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequests(@BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="state") String state, @QueryParam(value="role") String role, @QueryParam(value="participantStatus") String participantStatus, @QueryParam(value="order") List<String> orders, @QueryParam(value="closedSince") String closedSince, @QueryParam(value="user") String username) {
        this.permissionValidationService.validateAuthenticated();
        if (!StringUtils.isBlank((CharSequence)username)) {
            ApplicationUser user = this.userService.getUserByName(username);
            if (user == null) {
                throw new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchuser", new Object[]{username}));
            }
        } else {
            username = this.authenticationContext.getCurrentUser().getName();
        }
        PullRequestSearchRequest request = this.buildSearchRequest(role, state, participantStatus, orders, closedSince, username);
        Page pullRequestPage = this.pullRequestService.search(request, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(pullRequestPage, RestPullRequest.REST_TRANSFORM)).build();
    }

    @Operation(description="Retrieves a page of suggestions for pull requests that the currently authenticated user may wish to raise. Such suggestions are based on ref changes occurring and so contain the ref change that prompted the suggestion plus the time the change event occurred. Changes will be returned in descending order based on the time the change that prompted the suggestion occurred. \n\nNote that although the response is a page object, the interface does not support paging, however a limit can be applied to the size of the returned page.", summary="Get pull request suggestions")
    @Parameters(value={@Parameter(description="restrict pull request suggestions to be based on events that occurred since some timein the past. This is expressed in seconds since \"now\". So to return suggestionsbased only on activity within the past 48 hours, pass a value of 172800.", in=ParameterIn.QUERY, name="changesSince"), @Parameter(description="restricts the result set to return at most this many suggestions.", in=ParameterIn.QUERY, name="limit")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of pull requests that match the search criteria.", representation=RestPullRequestSuggestion.class, paged=true, addPageParameters=false, responseCode=200), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400), @ResponseDoc(documentation="The current user is not authenticated", restError=true, responseCode=401)})
    @GET
    @Path(value="pull-request-suggestions")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestSuggestions(@QueryParam(value="changesSince") @DefaultValue(value="172800") String changesSince, @QueryParam(value="limit") @DefaultValue(value="3") int limit) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        Page page = this.dashboardService.suggestPullRequests(new SuggestPullRequestsRequest.Builder(currentUser, this.parseDateTimeOffset(changesSince)).limit(limit).build());
        return ResponseFactory.ok((Object)new RestPage(page, RestPullRequestSuggestion.REST_TRANSFORM)).build();
    }

    private PullRequestSearchRequest buildSearchRequest(String roleParam, String stateParam, String participantStatusParam, List<String> orderParams, String closedSinceParam, String username) {
        Date closedSince = this.parseDateTimeOffset(closedSinceParam);
        PullRequestRole role = this.parseRole(roleParam);
        PullRequestState state = this.parseState(stateParam);
        Set<PullRequestParticipantStatus> participantStatus = this.parseParticipantStatus(participantStatusParam);
        List<PullRequestOrder> orders = this.parseOrders(orderParams);
        return new PullRequestSearchRequest.Builder().orders(orders).participant(new PullRequestParticipantRequest.Builder(username).role(role).statuses(participantStatus).build()).state(state).closedSince(closedSince).build();
    }

    private Date parseDateTimeOffset(String value) {
        if (value == null) {
            return null;
        }
        try {
            long closedSince = Long.parseLong(value);
            if (closedSince < 0L) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.datetime.offset.invalid", new Object[]{value}));
            }
            return new Date(System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(closedSince));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.datetime.offset.invalid", new Object[]{value}));
        }
    }

    private List<PullRequestOrder> parseOrders(List<String> values) {
        if (values.isEmpty()) {
            return DEFAULT_ORDER;
        }
        ArrayList orders = Lists.newArrayList();
        values.forEach(value -> {
            try {
                orders.add(PullRequestOrder.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.order.invalid", new Object[]{value, Arrays.asList(PullRequestOrder.values())}));
            }
        });
        return orders;
    }

    private Set<PullRequestParticipantStatus> parseParticipantStatus(String value) {
        if (value == null) {
            return new HashSet<PullRequestParticipantStatus>(Arrays.asList(PullRequestParticipantStatus.values()));
        }
        return (Set)Arrays.stream(value.split(",")).map(this::toParticipantStatus).collect(MoreCollectors.toImmutableSet());
    }

    private PullRequestRole parseRole(String value) {
        if (value == null) {
            return null;
        }
        try {
            return PullRequestRole.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.role.invalid", new Object[]{value, Arrays.asList(PullRequestRole.values())}));
        }
    }

    private PullRequestState parseState(String value) {
        if (value == null) {
            return null;
        }
        try {
            return PullRequestState.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.state.invalid", new Object[]{value, Arrays.asList(PullRequestState.values())}));
        }
    }

    private PullRequestParticipantStatus toParticipantStatus(String value) {
        try {
            return PullRequestParticipantStatus.valueOf((String)value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.dashboard.status.participant.invalid", new Object[]{value, Arrays.asList(PullRequestState.values())}));
        }
    }
}

