/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.deployment;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Map;

@UnrestrictedAccess
@Path(value="deployment/capabilities")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Capabilities")
public class DeploymentCapabilitiesResource {
    private static final Map<String, Object> CAPABILITIES = Collections.emptyMap();
    private static final String CAPABILITY_DISABLED = "plugin.deployment.capability.disabled";
    private final ApplicationPropertiesService propertiesService;

    @Inject
    public DeploymentCapabilitiesResource(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @Operation(description="Returns the Deployment capabilities of this instance", summary="Get deployment capabilities")
    @ResponseDocs(value={@ResponseDoc(documentation="capabilities", responseCode=200), @ResponseDoc(documentation="This instance of Bitbucket Data Center does not support deployments (for example, it has been disabled using the property 'plugin.deployment.capability.disabled').", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCapabilities() {
        if (this.propertiesService.getPluginProperty(CAPABILITY_DISABLED, false)) {
            return ResponseFactory.notFound().build();
        }
        return ResponseFactory.ok(CAPABILITIES, (CacheControl)CachePolicies.publicCacheForAnHour()).build();
    }
}

