/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.deployment;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.bitbucket.dmz.deployments.DeleteDeploymentRequest;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.atlassian.bitbucket.dmz.deployments.DeploymentService;
import com.atlassian.bitbucket.dmz.deployments.DeploymentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentSourceTool;
import com.atlassian.bitbucket.dmz.deployments.GetDeploymentRequest;
import com.atlassian.bitbucket.dmz.rest.v2.deployment.RestDeployment;
import com.atlassian.bitbucket.dmz.rest.v2.deployment.RestDeploymentEnvironment;
import com.atlassian.bitbucket.dmz.rest.v2.deployment.RestDeploymentSetRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.oauth.util.RequestAnnotations;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/deployments")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Builds and Deployments")
public class DeploymentResource {
    private static final Logger log = LoggerFactory.getLogger(DeploymentResource.class);
    private static final String USER_AGENT = "user-agent";
    private static final String JENKINS_USER_AGENT = "bitbucket-jenkins-integration";
    private final ApplicationLinkService applicationLinkService;
    private final DeploymentService deploymentService;
    private final I18nService i18nService;
    private final Validator validator;

    @Inject
    public DeploymentResource(ApplicationLinkService applicationLinkService, DeploymentService deploymentService, I18nService i18nService, Validator validator) {
        this.applicationLinkService = applicationLinkService;
        this.deploymentService = deploymentService;
        this.i18nService = i18nService;
        this.validator = validator;
    }

    @Operation(description="Create or update a deployment. \n\n The authenticated user must have REPO_READ permission for the repository.", summary="Create or update a deployment")
    @Parameters(value={@Parameter(description="the commitId that was deployed as indicated by the path", in=ParameterIn.PATH, name="commitId")})
    @RequestBody(description="the details of the deployment to create, as detailed by the request body", content={@Content(schema=@Schema(implementation=RestDeploymentSetRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The deployment was created", representation=RestDeployment.class, responseCode=200), @ResponseDoc(documentation="the deployment was not created because the request was invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @POST
    @EscalateAnonymous2LO(value={Permission.PROJECT_VIEW, Permission.REPO_READ})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createOrUpdateDeployment(@PathParam(value="commitId") String commitId, @BeanParam RepositoryResolver repositoryResolver, RestDeploymentSetRequest request, @Context HttpServletRequest servletRequest) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        ValidationUtils.validate((Validator)this.validator, (Object)request.getEnvironment(), (Class[])new Class[0]);
        RestDeploymentEnvironment restEnvironment = request.getEnvironment();
        DeploymentEnvironmentSetRequest environment = new DeploymentEnvironmentSetRequest.Builder(restEnvironment.getDisplayName(), restEnvironment.getKey()).type((DeploymentEnvironmentType)DeploymentEnvironmentType.fromString((String)restEnvironment.getType()).orElse(null)).url(this.getUrlFromString(restEnvironment.getUrl())).build();
        DeploymentSourceTool sourceTool = this.getSourceTool(servletRequest);
        Deployment created = this.deploymentService.set(new DeploymentSetRequest.Builder(commitId, request.getDeploymentSequenceNumber().longValue(), request.getDescription(), request.getDisplayName(), environment, request.getKey(), repositoryResolver.getRepository(), request.getState(), this.getUrlFromString(request.getUrl())).sourceTool(sourceTool).lastUpdated(request.getLastUpdated() == null ? null : new Date(request.getLastUpdated())).build());
        return Response.ok((Object)new RestDeployment(created)).build();
    }

    @Operation(description="Delete the deployment matching the specified Repository, key, environmentKey and deploymentSequenceNumber. \n\nThe user must have REPO_ADMIN.", summary="Delete a deployment")
    @Parameters(value={@Parameter(description="the commitId that was deployed as indicated by the path", in=ParameterIn.PATH, name="commitId"), @Parameter(description="the key of the deployment, as detailed by the query parameter", in=ParameterIn.QUERY, name="key"), @Parameter(description="the key of the environment, as detailed by the query parameter", in=ParameterIn.QUERY, name="environmentKey"), @Parameter(description="the sequence number of the deployment, as detailed by the query parameter", in=ParameterIn.QUERY, name="deploymentSequenceNumber")})
    @ResponseDocs(value={@ResponseDoc(documentation="the request has been processed", responseCode=204), @ResponseDoc(documentation="the deployment was not deleted because the request was invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete a deployment", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @DELETE
    @EscalateAnonymous2LO(value={Permission.PROJECT_VIEW, Permission.REPO_READ})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="key") String key, @QueryParam(value="environmentKey") String environmentKey, @QueryParam(value="deploymentSequenceNumber") Long deploymentSequenceNumber) {
        this.validateQueryParams(key, environmentKey, deploymentSequenceNumber);
        DeleteDeploymentRequest deleteDeploymentRequest = new DeleteDeploymentRequest(repositoryResolver.getRepository(), commitId, key, environmentKey, deploymentSequenceNumber.longValue());
        this.deploymentService.delete(deleteDeploymentRequest);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Get the deployment matching the specified Repository, key, environmentKey and deploymentSequenceNumber. \n\nThe user must have REPO_READ.", summary="Get a deployment")
    @Parameters(value={@Parameter(description="the commitId that was deployed as indicated by the query parameter", in=ParameterIn.PATH, name="commitId"), @Parameter(description="the key of the deployment, as detailed by the query parameter", in=ParameterIn.QUERY, name="key"), @Parameter(description="the key of the environment, as detailed by the query parameter", in=ParameterIn.QUERY, name="environmentKey"), @Parameter(description="the sequence number of the deployment, as detailed by the query param", in=ParameterIn.QUERY, name="deploymentSequenceNumber", example="deploymentSequenceNumber")})
    @ResponseDocs(value={@ResponseDoc(documentation="The deployment", representation=RestDeployment.class, responseCode=200), @ResponseDoc(documentation="could not get the deployment because the request was invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository or deployment does not exist", restError=true, responseCode=404)})
    @GET
    @EscalateAnonymous2LO(value={Permission.PROJECT_VIEW, Permission.REPO_READ})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="commitId") String commitId, @QueryParam(value="key") String key, @QueryParam(value="environmentKey") String environmentKey, @QueryParam(value="deploymentSequenceNumber") Long deploymentSequenceNumber) {
        this.validateQueryParams(key, environmentKey, deploymentSequenceNumber);
        return this.deploymentService.get(new GetDeploymentRequest(repositoryResolver.getRepository(), commitId, key, environmentKey, deploymentSequenceNumber.longValue())).map(deployment -> ResponseFactory.ok((Object)new RestDeployment(deployment))).orElseGet(ResponseFactory::notFound).build();
    }

    @Nonnull
    private DeploymentSourceTool getSourceTool(HttpServletRequest servletRequest) {
        String userAgent = StringUtils.lowerCase((String)servletRequest.getHeader(USER_AGENT));
        if (!StringUtils.isBlank((CharSequence)userAgent) && userAgent.startsWith(JENKINS_USER_AGENT)) {
            return DeploymentSourceTool.JENKINS;
        }
        String remoteClientId = Objects.toString(servletRequest.getAttribute("oauth2.token.client_configuration_id"), "");
        if (!remoteClientId.isBlank()) {
            log.debug("Searching for Application Link by client id '{}'", (Object)remoteClientId);
            return this.matchWithBamboo(applink -> remoteClientId.equals(applink.getClientId()));
        }
        if (RequestAnnotations.isOAuthRequest((HttpServletRequest)servletRequest)) {
            String oAuthConsumerKey = RequestAnnotations.getOAuthConsumerKey((HttpServletRequest)servletRequest);
            log.debug("Searching for Application Link by consumer key '{}'", (Object)oAuthConsumerKey);
            return this.matchWithBamboo(applink -> oAuthConsumerKey.equals(applink.getProperty("oauth.incoming.consumerkey")));
        }
        return DeploymentSourceTool.UNKNOWN;
    }

    private URI getUrlFromString(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.url.invalid", new Object[]{url}));
        }
    }

    private DeploymentSourceTool matchWithBamboo(@Nonnull Predicate<? super ApplicationLink> filter) {
        return MoreStreams.streamIterable((Iterable)this.applicationLinkService.getApplicationLinks(BambooApplicationType.class)).filter(filter).findFirst().map(applink -> DeploymentSourceTool.BAMBOO).orElse(DeploymentSourceTool.UNKNOWN);
    }

    private void validateQueryParams(String key, String environmentKey, Long deploymentSequenceNumber) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.delete.deployment.key.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)environmentKey)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.delete.environment.key.required", new Object[0]));
        }
        if (deploymentSequenceNumber == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.deployment.delete.sequenceNumber.required", new Object[0]));
        }
    }
}

