/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.hook;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="hooks")
@Singleton
@Tag(name="Project")
public class RepositoryHookAvatarResource {
    private final RepositoryHookService repositoryHookService;

    @Inject
    public RepositoryHookAvatarResource(RepositoryHookService repositoryHookService) {
        this.repositoryHookService = repositoryHookService;
    }

    @Operation(description="Retrieve the avatar for the project matching the supplied <strong>moduleKey</strong>.", summary="Get project avatar")
    @Parameters(value={@Parameter(description="The complete module key of the hook module.", in=ParameterIn.PATH, name="hookKey"), @Parameter(description="(optional) Version used for HTTP caching only - any non-blank version will result in a large max-age Cache-Control header. Note that this does not affect the Last-Modified header.", in=ParameterIn.QUERY, name="version")})
    @ResponseDocs(value={@ResponseDoc(documentation="The avatar of the project matching the supplied <strong>moduleKey</strong>.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{hookKey}/avatar")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAvatar(@Context ContainerRequestContext requestContext, @PathParam(value="hookKey") String hookKey, @QueryParam(value="version") String version) {
        boolean hasVersion = StringUtils.isNotEmpty((CharSequence)version) && !version.endsWith("-SNAPSHOT");
        CacheControl cacheControl = hasVersion ? CachePolicies.cacheForAMonth() : CachePolicies.noCache();
        return AvatarRequestHelper.processAvatarResponse((ContainerRequestContext)requestContext, (CacheControl)cacheControl, (CacheableAvatarSupplier)this.repositoryHookService.getAvatar(hookKey));
    }
}

