/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.hook;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.hook.repository.RestRepositoryHook;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.hook.RepositoryHookResourceHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/settings/hooks")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositoryHookRepositoryResource {
    private final RepositoryHookResourceHelper helper;

    @Inject
    public RepositoryHookRepositoryResource(RepositoryHookResourceHelper helper) {
        this.helper = helper;
    }

    @Operation(description="Delete repository hook configuration for the supplied <strong>hookKey</strong> and <strong>repositorySlug</strong>\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Delete repository hook")
    @Parameters(value={@Parameter(description="The hook key.", in=ParameterIn.PATH, name="hookKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The hook configuration matching the supplied <strong>hookKey</strong> and <strong>repositorySlug</strong> was deleted", responseCode=204), @ResponseDoc(documentation="The settings specified are invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the hook.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or hook does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{hookKey}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteRepositoryHook(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="hookKey") String hookKey) {
        return this.helper.deleteHook((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()), hookKey);
    }

    @Operation(description="Enable a repository hook for this repository and optionally apply new configuration. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource. \n\nA JSON document may be provided to use as the settings for the hook. These structure and validity of the document is decided by the plugin providing the hook.", summary="Enable repository hook")
    @Parameters(value={@Parameter(description="The hook key.", in=ParameterIn.PATH, name="hookKey"), @Parameter(description="The content length.", in=ParameterIn.HEADER, name="Content-Length"), @Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY).", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository hooks with their associated enabled state for the supplied hookKey.", representation=RestRepositoryHook.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to enable the hook.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or hook does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="{hookKey}/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response enableHook(@BeanParam ScopeResolver scopeResolver, @PathParam(value="hookKey") String hookKey, @QueryParam(value="enrich") boolean enrich, @Context ContainerRequestContext requestContext) {
        return this.helper.enableHook(scopeResolver.getScope(), hookKey, requestContext, enrich);
    }

    @Operation(description="Disable a repository hook for this repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Disable repository hook")
    @Parameters(value={@Parameter(description="The hook key.", in=ParameterIn.PATH, name="hookKey"), @Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY).", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository hooks with their associated enabled state for the supplied hookKey.", representation=RestRepositoryHook.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to disable the hook.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or hook does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{hookKey}/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response disableHook(@BeanParam ScopeResolver scopeResolver, @PathParam(value="hookKey") String hookKey, @QueryParam(value="enrich") boolean enrich) {
        return this.helper.disableHook(scopeResolver.getScope(), hookKey, enrich);
    }

    @Operation(description="Retrieve a page of repository hooks for this repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get repository hooks")
    @Parameters(value={@Parameter(description="The optional type to filter by.", in=ParameterIn.QUERY, name="type", schema=@Schema(allowableValues={"PRE_RECEIVE", "POST_RECEIVE"})), @Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY).", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repository hooks with their associated enabled state.", paged=true, representation=RestRepositoryHook.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the hooks.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryHooks(@BeanParam ScopeResolver scopeResolver, @DefaultValue(value="") @QueryParam(value="type") String typeAsString, @QueryParam(value="enrich") boolean enrich, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.helper.getRepositoryHooks(scopeResolver.getScope(), typeAsString, pageRequestResolver.getPageRequest(), enrich);
    }

    @Operation(description="Retrieve a repository hook for this repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get repository hook")
    @Parameters(value={@Parameter(description="The hook key.", in=ParameterIn.PATH, name="hookKey"), @Parameter(description="When set to true, an enriched response will be returned (INTERNAL USE ONLY).", in=ParameterIn.QUERY, name="enrich", hidden=true)})
    @ResponseDocs(value={@ResponseDoc(documentation="The repository hooks with their associated enabled state for the supplied hookKey.", representation=RestRepositoryHook.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the hook.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository hook does not exist for the given repository, or the repository does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{hookKey}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryHook(@BeanParam ScopeResolver scopeResolver, @PathParam(value="hookKey") String hookKey, @QueryParam(value="enrich") boolean enrich) {
        return this.helper.getRepositoryHook(scopeResolver.getScope(), hookKey, enrich);
    }

    @Operation(description="Retrieve the settings for a repository hook for this repository. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource.", summary="Get repository hook settings")
    @Parameters(value={@Parameter(description="The hook key.", in=ParameterIn.PATH, name="hookKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The settings for the hook.", representation=ExampleSettings.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the hook settings.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or hook does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{hookKey}/settings")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSettings(@BeanParam ScopeResolver scopeResolver, @PathParam(value="hookKey") String hookKey) {
        return this.helper.getSettings(scopeResolver.getScope(), hookKey);
    }

    @Operation(description="Modify the settings for a repository hook for this repository. \n\nThe service will reject any settings which are too large, the current limit is 32KB once serialized. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission for the specified repository to call this resource. \n\nA JSON document can be provided to use as the settings for the hook. These structure and validity of the document is decided by the plugin providing the hook.", summary="Update repository hook settings")
    @Parameters(value={@Parameter(description="The hook key.", in=ParameterIn.PATH, name="hookKey")})
    @RequestBody(content={@Content(schema=@Schema(implementation=ExampleSettings.class))}, description="The raw settings.")
    @ResponseDocs(value={@ResponseDoc(documentation="The settings for the hook.", representation=ExampleSettings.class, responseCode=200), @ResponseDoc(documentation="The settings specified are invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to modify the hook settings.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository or hook does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="{hookKey}/settings")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setSettings(@BeanParam ScopeResolver scopeResolver, @PathParam(value="hookKey") String hookKey, Map<String, Object> rawSettings) throws IOException {
        return this.helper.setSettings(scopeResolver.getScope(), hookKey, rawSettings);
    }

    static class ExampleSettings {
        ExampleSettings() {
        }

        @Schema(example="This is an arbitrary string")
        public String getStringValue() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="1")
        public int getIntegerValue() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="-2147483648")
        public long getLongValue() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="true")
        public boolean getBooleanValue() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="1.1")
        public double getDoubleValue() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

