/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.hook;

import com.atlassian.bitbucket.dmz.hook.script.RepositoryHookRestrictionEnricher;
import com.atlassian.bitbucket.dmz.hook.script.RestrictedRepositoryHook;
import com.atlassian.bitbucket.dmz.rest.v2.hook.repository.RestRepositoryHook;
import com.atlassian.bitbucket.dmz.rest.v2.hook.repository.RestRestrictedRepositoryHook;
import com.atlassian.bitbucket.hook.repository.DeleteRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.DisableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.EnableRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.GetRepositoryHookSettingsRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSearchRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookSettings;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.hook.repository.SetRepositoryHookSettingsRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.NotFoundException;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RepositoryHookResourceHelper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final I18nService i18nService;
    private final RepositoryHookRestrictionEnricher repositoryHookRestrictionEnricher;
    private final RepositoryHookService repositoryHookService;

    public RepositoryHookResourceHelper(I18nService i18nService, RepositoryHookRestrictionEnricher repositoryHookRestrictionEnricher, RepositoryHookService repositoryHookService) {
        this.i18nService = i18nService;
        this.repositoryHookRestrictionEnricher = repositoryHookRestrictionEnricher;
        this.repositoryHookService = repositoryHookService;
    }

    public Response deleteHook(Scope scope, String hookKey) {
        DeleteRepositoryHookRequest request = new DeleteRepositoryHookRequest.Builder(scope, hookKey).build();
        this.repositoryHookService.delete(request);
        return ResponseFactory.noContent().build();
    }

    public Response disableHook(Scope scope, String hookKey, boolean enrich) {
        DisableRepositoryHookRequest request = new DisableRepositoryHookRequest.Builder(scope, hookKey).build();
        RepositoryHook descriptor = this.repositoryHookService.disable(request);
        return this.getFinalResponse(descriptor, enrich);
    }

    public Response enableHook(Scope scope, String hookKey, ContainerRequestContext requestContext, boolean enrich) {
        Map rawSettings = null;
        try {
            if (requestContext.hasEntity()) {
                rawSettings = (Map)OBJECT_MAPPER.readValue(requestContext.getEntityStream(), Map.class);
            }
        }
        catch (IOException ioException) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.entity.stream.invalid", new Object[]{"enabling hooks"}));
        }
        EnableRepositoryHookRequest.Builder enableRequest = new EnableRepositoryHookRequest.Builder(scope, hookKey);
        if (rawSettings != null) {
            enableRequest.settings(this.createSettings(rawSettings));
        }
        RepositoryHook descriptor = this.repositoryHookService.enable(enableRequest.build());
        return this.getFinalResponse(descriptor, enrich);
    }

    public Response getRepositoryHook(Scope scope, String hookKey, boolean enrich) {
        RepositoryHook descriptor = this.getHookByKey(scope, hookKey);
        return this.getFinalResponse(descriptor, enrich);
    }

    public Response getRepositoryHooks(Scope scope, String typeAsString, PageRequest pageRequest, boolean enrich) {
        RepositoryHookSearchRequest.Builder request = new RepositoryHookSearchRequest.Builder(scope);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{typeAsString})) {
            try {
                request.type(RepositoryHookType.valueOf((String)typeAsString));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.hook.bad.type", new Object[]{typeAsString}));
            }
        }
        Page page = this.repositoryHookService.search(request.build(), pageRequest);
        return this.getPagedResponse((Page<RepositoryHook>)page, scope, enrich);
    }

    public Response getSettings(Scope scope, String hookKey) {
        GetRepositoryHookSettingsRequest request = new GetRepositoryHookSettingsRequest.Builder(scope, hookKey).build();
        RepositoryHookSettings settings = this.repositoryHookService.getSettings(request);
        if (settings == null) {
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.ok((Object)settings.getSettings().asMap()).build();
    }

    public Response setSettings(Scope scope, String hookKey, Map<String, Object> rawSettings) {
        Settings settings = this.createSettings(rawSettings);
        SetRepositoryHookSettingsRequest request = new SetRepositoryHookSettingsRequest.Builder(scope, hookKey).settings(settings).build();
        return ResponseFactory.ok((Object)this.repositoryHookService.setSettings(request).asMap()).build();
    }

    private Settings createSettings(Map<String, Object> rawSettings) {
        try {
            return this.repositoryHookService.createSettingsBuilder().addAll(rawSettings).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.settings.malformed", new Object[0]));
        }
    }

    private Response getFinalResponse(RepositoryHook descriptor, boolean enrich) {
        if (enrich) {
            RestrictedRepositoryHook enrichedDescriptor = this.repositoryHookRestrictionEnricher.enrich(descriptor);
            return ResponseFactory.ok((Object)new RestRestrictedRepositoryHook(enrichedDescriptor)).build();
        }
        return ResponseFactory.ok((Object)new RestRepositoryHook(descriptor)).build();
    }

    private RepositoryHook getHookByKey(Scope scope, String hookKey) {
        RepositoryHook descriptor = this.repositoryHookService.getByKey(scope, hookKey);
        if (descriptor == null) {
            throw new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchrepositoryhook", new Object[]{hookKey}));
        }
        return descriptor;
    }

    private Response getPagedResponse(Page<RepositoryHook> page, Scope scope, boolean enrich) {
        if (enrich) {
            Page enrichedPage = this.repositoryHookRestrictionEnricher.enrichPage(page, scope);
            return ResponseFactory.ok((Object)new RestPage(enrichedPage, RestRestrictedRepositoryHook::new)).build();
        }
        return ResponseFactory.ok((Object)new RestPage(page, RestRepositoryHook::new)).build();
    }
}

