/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.hook.script;

import com.atlassian.bitbucket.dmz.hook.script.DmzHookScriptService;
import com.atlassian.bitbucket.dmz.rest.v2.hook.script.RestHookScriptConfig;
import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.hook.script.HookScriptConfig;
import com.atlassian.bitbucket.hook.script.HookScriptRemoveConfigurationRequest;
import com.atlassian.bitbucket.hook.script.HookScriptSetConfigurationRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.ws.rs.core.Response;
import java.util.Set;

public class AbstractScopedHookScriptResource {
    protected final DmzHookScriptService scriptService;

    protected AbstractScopedHookScriptResource(DmzHookScriptService scriptService) {
        this.scriptService = scriptService;
    }

    protected Response getConfigurations(Scope scope, PageRequest pageRequest) {
        Page page = this.scriptService.findConfigsByScope(scope, pageRequest);
        return ResponseFactory.ok((Object)new RestPage(page, RestHookScriptConfig::new)).build();
    }

    protected Response removeConfiguration(Scope scope, long scriptId) {
        HookScript script = this.scriptService.getById(scriptId);
        this.scriptService.removeConfiguration(new HookScriptRemoveConfigurationRequest.Builder(script, scope).build());
        return ResponseFactory.noContent().build();
    }

    protected Response setConfiguration(Scope scope, long scriptId, Set<String> triggerIds) {
        HookScript script = this.scriptService.getById(scriptId);
        HookScriptSetConfigurationRequest request = new HookScriptSetConfigurationRequest.Builder(script, scope).triggerIds(triggerIds).build();
        HookScriptConfig config = this.scriptService.setConfiguration(request);
        return ResponseFactory.ok((Object)new RestHookScriptConfig(config)).build();
    }
}

