/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.hook.script;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.hook.script.DmzHookScriptService;
import com.atlassian.bitbucket.dmz.rest.v2.hook.script.RestHookScript;
import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.hook.script.HookScriptCreateRequest;
import com.atlassian.bitbucket.hook.script.HookScriptService;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.hook.script.HookScriptUpdateRequest;
import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfig;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.component.ComponentLocator;
import com.google.common.io.ByteStreams;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Path(value="hook-scripts")
@Singleton
@Tag(name="System Maintenance")
public class HookScriptResource {
    private static final String PLUGIN_KEY = "com.atlassian.bitbucket.server.bitbucket-hook-scripts";
    private final DmzHookScriptService scriptService;

    @Inject
    public HookScriptResource(DmzHookScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Operation(description="Create a new hook script.\n\nThis endpoint requires **SYS_ADMIN** permission.", summary="Create a new hook script")
    @RequestBody(description="The multipart form data containing the hook script", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExamplePostMultipartFormData.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created hook script.", representation=RestHookScript.class, responseCode=200), @ResponseDoc(documentation="The hook script was not created due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions.", responseCode=401, restError=true)})
    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=HookScriptMultipartConfig.class)
    @Produces(value={"application/json;charset=UTF-8"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createHookScript(@MultipartFormParam(value="content") FilePart contentPart, @MultipartFormParam(value="description") FilePart descriptionPart, @MultipartFormParam(value="name") FilePart namePart, @MultipartFormParam(value="type") FilePart typePart) {
        String description = descriptionPart == null ? null : HookScriptResource.read(descriptionPart, "description");
        String name = HookScriptResource.read(namePart, "name");
        HookScriptType type = HookScriptResource.readType(typePart);
        HookScriptCreateRequest request = new HookScriptCreateRequest.Builder(name, PLUGIN_KEY, type).content(() -> ((FilePart)contentPart).getInputStream()).description(description).build();
        HookScript script = this.scriptService.create(request);
        return ResponseFactory.ok((Object)new RestHookScript(script)).build();
    }

    @Operation(description="Deletes a registered hook script.\n\nThis endpoint requires **SYS_ADMIN** permission.", summary="Delete a hook script.")
    @Parameters(value={@Parameter(name="scriptId", description="The ID of the hook script to delete", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The hook script was deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions.", responseCode=401, restError=true), @ResponseDoc(documentation="Unable to find the supplied hook script ID.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{scriptId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteHookScript(@PathParam(value="scriptId") long scriptId) {
        HookScript script = this.scriptService.getById(scriptId);
        this.scriptService.delete(script);
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieves a hook script by ID.", summary="Get a hook script")
    @Parameters(value={@Parameter(name="scriptId", description="The ID of the hook script to retrieve", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The hook script.", representation=RestHookScript.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions.", responseCode=401, restError=true), @ResponseDoc(documentation="The hook script ID supplied does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{scriptId}")
    @Produces(value={"application/json;charset=UTF-8"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getHookScript(@PathParam(value="scriptId") long scriptId) {
        HookScript script = this.scriptService.getById(scriptId);
        return ResponseFactory.ok((Object)new RestHookScript(script)).build();
    }

    @Operation(description="Retrieves the hook script content.\n\nThis endpoint requires **SYS_ADMIN** permission.", summary="Get hook script content")
    @Parameters(value={@Parameter(name="scriptId", description="The ID of the hook script", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The hook script content.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions.", responseCode=401, restError=true), @ResponseDoc(documentation="The hook script ID supplied does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{scriptId}/content")
    @Produces(value={"application/octet-stream", "text/plain;charset=UTF-8"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response read(@PathParam(value="scriptId") long scriptId) {
        HookScript script = this.scriptService.getById(scriptId);
        return ResponseFactory.ok((httpHeaders, outputStream) -> {
            InputSupplier content = this.scriptService.read(script);
            try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)content.open(), 32768);){
                if (ContentDetectionUtils.isBinary((InputStream)inputStream, (int)8192)) {
                    httpHeaders.putSingle((Object)"Content-Type", (Object)"application/octet-stream");
                } else {
                    httpHeaders.putSingle((Object)"Content-Type", (Object)"text/plain;charset=UTF-8");
                }
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }).build();
    }

    @Operation(description="Updates a hook script.\n\nThis endpoint requires **SYS_ADMIN** permission.", summary="Update a hook script")
    @Parameters(value={@Parameter(name="scriptId", description="The ID of the hook script", in=ParameterIn.PATH)})
    @RequestBody(description="The multipart form data containing the hook script", content={@Content(schema=@Schema(implementation=ExamplePutMultipartFormData.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated hook script.", representation=RestHookScript.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions.", responseCode=401, restError=true), @ResponseDoc(documentation="The hook script ID supplied does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="A hook script with the same name already exists.", responseCode=409, restError=true), @ResponseDoc(documentation="One or more fields to update must be specified: content, description and/or name.", responseCode=422, restError=true)})
    @PUT
    @Path(value="{scriptId}")
    @Produces(value={"application/json;charset=UTF-8"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateHookScript(@PathParam(value="scriptId") long scriptId, @MultipartFormParam(value="content") FilePart contentPart, @MultipartFormParam(value="description") FilePart descriptionPart, @MultipartFormParam(value="name") FilePart namePart) {
        if (contentPart == null && descriptionPart == null && namePart == null) {
            return ResponseFactory.status((int)422).entity((Object)new RestErrors("One or more fields to update must be specified: content, description and/or name")).build();
        }
        HookScriptUpdateRequest.Builder builder = new HookScriptUpdateRequest.Builder(this.scriptService.getById(scriptId));
        if (contentPart != null) {
            builder.content(() -> ((FilePart)contentPart).getInputStream());
        }
        if (descriptionPart != null) {
            builder.description(HookScriptResource.read(descriptionPart, "description"));
        }
        if (namePart != null) {
            builder.name(HookScriptResource.read(namePart, "name"));
        }
        HookScript script = this.scriptService.update(builder.build());
        return ResponseFactory.ok((Object)new RestHookScript(script)).build();
    }

    private static String read(FilePart part, String name) {
        String string;
        block8: {
            InputStream inputStream = part.getInputStream();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BadRequestException("Failed to read " + name);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static HookScriptType readType(FilePart part) {
        String value = HookScriptResource.read(part, "type");
        try {
            return HookScriptType.valueOf((String)StringUtils.upperCase((String)value, (Locale)Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(value + " is not a valid hook script type");
        }
    }

    private static class ExamplePutMultipartFormData {
        private ExamplePutMultipartFormData() {
        }

        @Schema(description="The hook script contents.")
        public String getContent() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="A description of the hook script (useful when querying registered hook scripts).")
        public String getDescription() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The name of the hook script (useful when querying registered hook scripts).")
        public String getName() {
            throw new RuntimeException("This method should not be invoked");
        }
    }

    private static class ExamplePostMultipartFormData {
        private ExamplePostMultipartFormData() {
        }

        @Schema(description="The hook script contents.")
        public String getContent() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="A description of the hook script (useful when querying registered hook scripts).")
        public String getDescription() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The name of the hook script (useful when querying registered hook scripts).")
        public String getName() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(description="The type of hook script; supported values are \"PRE\" for pre-receive hooks and \"POST\" for post-receive hooks.")
        public String getType() {
            throw new RuntimeException("This method should not be invoked");
        }
    }

    public static class HookScriptMultipartConfig
    implements MultipartConfig {
        private final HookScriptService scriptService = (HookScriptService)ComponentLocator.getComponent(HookScriptService.class);

        public long getMaxFileSize() {
            return this.scriptService.getMaxSize();
        }

        public long getMaxSize() {
            return this.scriptService.getMaxSize() + 1000;
        }
    }
}

