/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.hook.script;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.hook.script.DmzHookScriptService;
import com.atlassian.bitbucket.dmz.rest.v2.hook.script.RestHookScriptConfig;
import com.atlassian.bitbucket.dmz.rest.v2.hook.script.RestHookScriptTriggers;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.hook.script.AbstractScopedHookScriptResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/hook-scripts")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RepositoryHookScriptResource
extends AbstractScopedHookScriptResource {
    @Inject
    public RepositoryHookScriptResource(DmzHookScriptService scriptService) {
        super(scriptService);
    }

    @Operation(description="Return a page of hook scripts configured for the specified repository. \n\nThis endpoint requires **REPO_ADMIN** permission.", summary="Get hook scripts")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of hook scripts.", paged=true, representation=RestHookScriptConfig.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getConfigurations(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.getConfigurations((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()), pageRequestResolver.getPageRequest());
    }

    @Operation(description="Removes the hook script from the set of hook scripts configured to run in the repository. \n\nThis endpoint requires **REPO_ADMIN** permission.", summary="Remove a hook script")
    @Parameters(value={@Parameter(name="scriptId", description="The ID of the hook script", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The hook script was successfully deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository slug or hook script ID supplied does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{scriptId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response removeConfiguration(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="scriptId") long scriptId) {
        return this.removeConfiguration((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()), scriptId);
    }

    @Operation(description="Creates/updates the hook script configuration for the provided hook script and repository. \n\nThis endpoint requires **REPO_ADMIN** permission.", summary="Create/update a hook script")
    @Parameters(value={@Parameter(name="scriptId", description="The ID of the hook script", in=ParameterIn.PATH)})
    @RequestBody(description="The hook triggers for which the hook script should be run", content={@Content(schema=@Schema(implementation=RestHookScriptTriggers.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The updated hook script.", representation=RestHookScriptConfig.class, responseCode=200), @ResponseDoc(documentation="The hook script was not created/updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the specified repository.", responseCode=401, restError=true), @ResponseDoc(documentation="The repository slug supplied does not exist.", responseCode=404, restError=true)})
    @Path(value="{scriptId}")
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setConfiguration(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="scriptId") long scriptId, RestHookScriptTriggers triggers) {
        return this.setConfiguration((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()), scriptId, triggers.getTriggerIds());
    }
}

