/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inbox;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="inbox")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class InboxResource {
    private static final List<PullRequestOrder> DRAFT_STATUS_ORDER = ImmutableList.of((Object)PullRequestOrder.DRAFT_STATUS);
    private static final Set<PullRequestOrder> PARTICIPANT_AND_DRAFT_STATUS_ORDER = ImmutableSet.of((Object)PullRequestOrder.PARTICIPANT_STATUS, (Object)PullRequestOrder.DRAFT_STATUS);
    private static final Logger log = LoggerFactory.getLogger(InboxResource.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestService pullRequestService;

    @Inject
    public InboxResource(I18nService i18nService, AuthenticationContext authenticationContext, PermissionValidationService permissionValidationService, PullRequestService pullRequestService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestService = pullRequestService;
    }

    @Operation(description="Returns a page of pull requests in the user's inbox.", summary="Get pull requests in inbox")
    @GET
    @Path(value="pull-requests")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequests(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="role") @DefaultValue(value="reviewer") String role) {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        log.debug("Retrieving pull requests for user {}", (Object)currentUser.getDisplayName());
        PageRequestImpl pageRequest = new PageRequestImpl(start, limit);
        Page pullRequestPage = this.pullRequestService.search(new PullRequestSearchRequest.Builder().orders(role.equals(PullRequestRole.AUTHOR.name()) ? DRAFT_STATUS_ORDER : PARTICIPANT_AND_DRAFT_STATUS_ORDER).participant(new PullRequestParticipantRequest.Builder(currentUser.getName()).role(this.parseRole(role)).statuses((Iterable)ImmutableList.of((Object)PullRequestParticipantStatus.UNAPPROVED, (Object)PullRequestParticipantStatus.NEEDS_WORK)).build()).state(PullRequestState.OPEN).build(), (PageRequest)pageRequest);
        return ResponseFactory.ok((Object)new RestPage(pullRequestPage, RestPullRequest.REST_TRANSFORM)).build();
    }

    @Operation(description="Returns the total number of pull requests in the user's inbox", summary="Get total number of pull requests in inbox")
    @GET
    @Path(value="pull-requests/count")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getPullRequestCount() {
        this.permissionValidationService.validateAuthenticated();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        log.debug("Retrieving pull request count for user {}", (Object)currentUser.getDisplayName());
        long count = this.pullRequestService.count(new PullRequestSearchRequest.Builder().participant(new PullRequestParticipantRequest.Builder(currentUser.getName()).role(PullRequestRole.REVIEWER).status(PullRequestParticipantStatus.UNAPPROVED).build()).state(PullRequestState.OPEN).build());
        HashMap response = Maps.newHashMap();
        response.put("count", count);
        return ResponseFactory.ok((Object)response).build();
    }

    private PullRequestRole parseRole(String role) {
        try {
            return PullRequestRole.valueOf((String)role.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getText("bitbucket.rest.inbox.role.invalid", null, new Object[]{role, Arrays.asList(PullRequestRole.values())}));
        }
    }
}

