/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.label;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.label.RestLabel;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.label.LabelService;
import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.label.LabelableSearchRequest;
import com.atlassian.bitbucket.label.LabelableType;
import com.atlassian.bitbucket.label.LabelableVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.OptionalServiceRegistry;
import com.atlassian.stash.internal.rest.label.RestLabelable;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="labels")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
public class LabelResource {
    private final I18nService i18nService;
    private final OptionalServiceRegistry serviceRegistry;

    @Inject
    public LabelResource(I18nService i18nService, OptionalServiceRegistry serviceRegistry) {
        this.i18nService = i18nService;
        this.serviceRegistry = serviceRegistry;
    }

    @Operation(description="Returns a paged response of all the labels in the system.\n\nThe user needs to be authenticated to use this resource.", summary="Get all labels")
    @Parameter(description="(optional) prefix to filter the labels on.", in=ParameterIn.QUERY, name="prefix")
    @ResponseDocs(value={@ResponseDoc(documentation="Page of returned labels.", paged=true, representation=RestLabel.class, responseCode=200), @ResponseDoc(documentation="The user is currently not authenticated.", restError=true, responseCode=401)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLabels(@QueryParam(value="prefix") String prefix, @BeanParam PageRequestResolver pageRequestResolver) {
        LabelService labelService = this.serviceRegistry.getLabelServiceOrThrow();
        Page page = StringUtils.isBlank((CharSequence)prefix) ? labelService.findAll(pageRequestResolver.getPageRequest()) : labelService.findByPrefix(prefix, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestLabel::new)).build();
    }

    @Operation(description="Returns a page of labelables for a given label.\n\nOnly labelables that the authenticated user has view access to will be returned.", summary="Get labelables for label")
    @Parameters(value={@Parameter(description="The page of labelables.", in=ParameterIn.PATH, name="labelName"), @Parameter(description=" the type of labelables to be returned. Supported values: REPOSITORY", in=ParameterIn.QUERY, name="type")})
    @ResponseDocs(value={@ResponseDoc(documentation="The page of labelables.", paged=true, representation=RestLabelable.class, responseCode=200), @ResponseDoc(documentation="The type of labelable is incorrect, correct values are REPOSITORY.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the labelables", restError=true, responseCode=401), @ResponseDoc(documentation="The specified label does not exist.", restError=true, responseCode=404)})
    @Path(value="{labelName}/labeled")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLabelables(@PathParam(value="labelName") String labelName, @QueryParam(value="type") String type, @BeanParam PageRequestResolver pageRequestResolver) {
        return ResponseFactory.ok(this.transform(this.labelables(labelName, type, pageRequestResolver.getPageRequest()))).build();
    }

    @Operation(description="Returns a label.\n\nThe user needs to be authenticated to use this resource.", summary="Get label")
    @Parameter(description="the label name", in=ParameterIn.PATH, name="labelName")
    @ResponseDocs(value={@ResponseDoc(documentation="The label.", representation=RestLabel.class, responseCode=200), @ResponseDoc(documentation="The user is currently not authenticated.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified label does not exist.", restError=true, responseCode=404)})
    @Path(value="{labelName}")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLabel(@PathParam(value="labelName") String labelName) {
        return ResponseFactory.ok((Object)new RestLabel(this.serviceRegistry.getLabelServiceOrThrow().getByName(labelName))).build();
    }

    private LabelableType getLabelableType(String type) {
        try {
            return type != null ? LabelableType.valueOf((String)type.toUpperCase(Locale.ROOT)) : null;
        }
        catch (IllegalArgumentException ex) {
            String possibleTypes = Arrays.stream(LabelableType.values()).map(Enum::name).collect(Collectors.joining(", "));
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.labelable.type", new Object[]{type, possibleTypes}));
        }
    }

    private Page<? extends Labelable> labelables(String labelName, String type, PageRequest pageRequest) {
        LabelService labelService = this.serviceRegistry.getLabelServiceOrThrow();
        LabelableSearchRequest searchRequest = new LabelableSearchRequest.Builder(labelService.getByName(labelName)).type(this.getLabelableType(type)).build();
        return labelService.searchLabelables(searchRequest, pageRequest);
    }

    private RestPage<Object> transform(Page<? extends Labelable> page) {
        return new RestPage(page, labelable -> labelable.accept((LabelableVisitor)new LabelableVisitor<Object>(this){

            public Object visit(@Nonnull Repository repository) {
                return new RestLabelable(repository);
            }
        }));
    }
}

