/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.license;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.rest.v2.license.RestBitbucketLicense;
import com.atlassian.bitbucket.dmz.rest.v2.license.RestLicenseStatus;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/license")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class LicenseResource {
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;
    private final PermissionValidationService validationService;

    @Inject
    public LicenseResource(I18nService i18nService, LicenseService licenseService, ApplicationPropertiesService propertiesService, PermissionValidationService validationService) {
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.propertiesService = propertiesService;
        this.validationService = validationService;
    }

    @Operation(description="Retrieves details about the current license, as well as the current status of the system with regards to the installed license. The status includes the current number of users applied toward the license limit, as well as any status messages about the license (warnings about expiry or user counts exceeding license limits). \n\nThe authenticated user must have <b>ADMIN</b> permission. Unauthenticated users, and non-administrators, are not permitted to access license details.", summary="Get license details")
    @ResponseDocs(value={@ResponseDoc(documentation="The currently-installed license.", representation=RestBitbucketLicense.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the license, or the request is anonymous.", restError=true, responseCode=401), @ResponseDoc(documentation="No license has been installed.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get() {
        this.validationService.validateForGlobal(Permission.ADMIN);
        return this.getAndTransform();
    }

    @Operation(description="Decodes the provided encoded license and sets it as the active license. If no license was provided, a 400 is returned. If the license cannot be decoded, or cannot be applied, a 409 is returned. Some possible reasons a license may not be applied include: \n\n- It is for a different product\n- It is already expired\n\n\nOtherwise, if the license is updated successfully, details for the new license are returned with a 200 response.\n\n<b>Warning</b>: It is possible to downgrade the license during update, applying a license with a lower number of permitted users. If the number of currently-licensed users exceeds the limits of the new license, pushing will be disabled until the licensed user count is brought into compliance with the new license.\n\nThe authenticated user must have <b>SYS_ADMIN</b> permission. <b>ADMIN</b> users may <i>view</i> the current license details, but they may not <i>update</i> the license.", summary="Update license")
    @RequestBody(description="a JSON payload containing the encoded license to apply", content={@Content(schema=@Schema(implementation=RestBitbucketLicense.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The newly-installed license.", representation=RestBitbucketLicense.class, responseCode=200), @ResponseDoc(documentation="No encoded license was provided in the JSON body for the POST.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the license.", restError=true, responseCode=401), @ResponseDoc(documentation="The encoded license could not be decoded, or it is not valid for use on this server. Some possible reasons a license may not be applied include: it may be for a different product, it may have already expired, or this Bitbucket version doesn't support Server licenses.", restError=true, responseCode=409)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateLicense(RestBitbucketLicense restLicense) {
        String license = restLicense.getLicense();
        if (StringUtils.isBlank((CharSequence)license)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.license.nolicenseprovided", new Object[0]));
        }
        try {
            this.licenseService.set(license);
        }
        catch (InvalidLicenseException e) {
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)new RestErrors((ServiceException)e)).build();
        }
        return this.getAndTransform();
    }

    private Response getAndTransform() {
        BitbucketServerLicense license = this.licenseService.get();
        if (license == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.rest.license.nolicenseset", new Object[]{Product.NAME}));
        }
        RestLicenseStatus status = new RestLicenseStatus(this.propertiesService.getServerId(), this.licenseService.getLicensedUsersCount(), this.licenseService.getOverLimitMessage(), this.licenseService.getValidityMessage());
        return ResponseFactory.ok((Object)new RestBitbucketLicense(license, this.licenseService.getAsString(), status)).build();
    }
}

