/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.log;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.log.DmzLoggingService;
import com.atlassian.bitbucket.dmz.mirror.MirrorAvailable;
import com.atlassian.bitbucket.dmz.profiling.DmzProfilingService;
import com.atlassian.bitbucket.dmz.rest.v2.log.RestLoggingSettings;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.log.RestLogLevel;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

@Consumes(value={"application/json"})
@Path(value="logs")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AdminOnly
@MirrorAvailable
@WebSudoRequired
@Tag(name="System Maintenance")
public class LoggingResource {
    private final I18nService i18nService;
    private final DmzLoggingService loggingService;
    private final DmzProfilingService profilingService;

    @Inject
    public LoggingResource(DmzLoggingService loggingService, DmzProfilingService profilingService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.loggingService = loggingService;
        this.profilingService = profilingService;
    }

    @Operation(description="Retrieve the current log level for a given logger.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Get current log level")
    @Parameter(description="The name of the logger.", in=ParameterIn.PATH, name="loggerName")
    @ResponseDocs(value={@ResponseDoc(documentation="The log level of the logger.", representation=RestLogLevel.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the log level.", restError=true, responseCode=401)})
    @Path(value="logger/{loggerName}")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLevel(@PathParam(value="loggerName") String loggerName) {
        String level = this.loggingService.getLevel(loggerName);
        return ResponseFactory.ok((Object)((Object)new RestLogLevel(level))).build();
    }

    @Operation(description="Retrieve the current log level for the root logger.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Get root log level")
    @ResponseDocs(value={@ResponseDoc(documentation="The log level of the logger.", representation=RestLogLevel.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve the log level.", restError=true, responseCode=401)})
    @Path(value="rootLogger")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRootLevel() {
        String level = this.loggingService.getRootLevel();
        return ResponseFactory.ok((Object)((Object)new RestLogLevel(level))).build();
    }

    @Operation(description="Returns whether debug logging and profiling are enabled.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission to call this resource.", summary="Get debug logging and profiling")
    @ResponseDocs(value={@ResponseDoc(documentation="Whether debug logging and profiling are enabled.", responseCode=200, representation=RestLoggingSettings.class), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve these settings.", restError=true, responseCode=401)})
    @Path(value="settings")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSettings() {
        return ResponseFactory.ok((Object)new RestLoggingSettings(this.loggingService.isDebugLoggingEnabled(), this.profilingService.isProfilingEnabled())).build();
    }

    @Operation(description="Set the current log level for a given logger.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Set log level")
    @Parameters(value={@Parameter(description="The level to set the logger to. Either TRACE, DEBUG, INFO, WARN or ERROR", in=ParameterIn.PATH, name="levelName"), @Parameter(description="The name of the logger.", in=ParameterIn.PATH, name="loggerName")})
    @ResponseDocs(value={@ResponseDoc(documentation="The log level was successfully changed.", responseCode=204), @ResponseDoc(documentation="The log level was invalid.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set the log level.", restError=true, responseCode=401)})
    @Path(value="logger/{loggerName}/{levelName}")
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setLevel(@PathParam(value="loggerName") String loggerName, @PathParam(value="levelName") String levelName) {
        try {
            this.loggingService.setLevel(loggerName, levelName);
            return ResponseFactory.noContent().build();
        }
        catch (IllegalArgumentException e) {
            throw this.translate(e);
        }
    }

    @Operation(description="Set the current log level for the root logger.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission or higher to call this resource.", summary="Set root log level")
    @Parameter(description="the level to set the logger to. Either TRACE, DEBUG, INFO, WARN or ERROR", in=ParameterIn.PATH, name="levelName")
    @ResponseDocs(value={@ResponseDoc(documentation="The log level was successfully changed.", responseCode=204), @ResponseDoc(documentation="The log level was invalid.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to set the log level.", restError=true, responseCode=401)})
    @Path(value="rootLogger/{levelName}")
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setRootLevel(@PathParam(value="levelName") String levelName) {
        try {
            this.loggingService.setRootLevel(levelName);
            return ResponseFactory.noContent().build();
        }
        catch (IllegalArgumentException e) {
            throw this.translate(e);
        }
    }

    @Operation(description="Set whether debug logging and profiling should be enabled. This setting persists on restarts.\n\nThe authenticated user must have <strong>SYS_ADMIN</strong> permission to call this resource.", summary="Set debug logging and profiling")
    @ResponseDocs(value={@ResponseDoc(documentation="Debug logging and profiling were successfully updated.", responseCode=200, representation=RestLoggingSettings.class), @ResponseDoc(documentation="The settings were not correctly specified.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update these settings.", restError=true, responseCode=401)})
    @Path(value="settings")
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setSettings(RestLoggingSettings loggingSettings) {
        List<RestErrorMessage> requestErrors = this.validate(loggingSettings);
        if (!requestErrors.isEmpty()) {
            return ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)new RestErrors(requestErrors)).build();
        }
        this.loggingService.setDebugLoggingEnabled(loggingSettings.isDebugLoggingEnabled().booleanValue());
        this.profilingService.setProfilingEnabled(loggingSettings.isProfilingEnabled().booleanValue());
        return ResponseFactory.ok((Object)loggingSettings).build();
    }

    private BadRequestException translate(IllegalArgumentException e) {
        return new BadRequestException(e.getMessage());
    }

    private List<RestErrorMessage> validate(RestLoggingSettings loggingSettings) {
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        if (loggingSettings.isDebugLoggingEnabled() == null) {
            errors.add(new RestErrorMessage("debugLogging", this.i18nService.getMessage("bitbucket.rest.log.settings.debuglogging.invalid", new Object[0])));
        }
        if (loggingSettings.isProfilingEnabled() == null) {
            errors.add(new RestErrorMessage("profiling", this.i18nService.getMessage("bitbucket.rest.log.settings.profiling.invalid", new Object[0])));
        }
        return errors;
    }
}

