/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.mergequeue;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettings;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.mergequeue.SetMergeQueueSettingsRequest;
import com.atlassian.bitbucket.dmz.rest.v2.mergequeue.RestMergeQueueSettings;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.stash.internal.rest.mergequeue.RestSetMergeQueueSettingsRequest;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

public abstract class AbstractMergeQueueSettingsResource {
    protected final MergeQueueSettingsService mergeQueueSettingsService;
    private final I18nService i18nService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;

    protected AbstractMergeQueueSettingsResource(I18nService i18nService, MergeQueueSettingsService mergeQueueSettingsService, ProjectSettingsRestrictionService projectSettingsRestrictionService) {
        this.i18nService = i18nService;
        this.mergeQueueSettingsService = mergeQueueSettingsService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
    }

    @Nonnull
    protected Response doGetMergeQueueSettings(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        MergeQueueSettings settings = this.mergeQueueSettingsService.getInheritedOrDefault(scope);
        ProjectSettingsRestrictionState restrictionState = this.getRestrictionState(scope);
        return Response.ok((Object)new RestMergeQueueSettings(settings, restrictionState)).build();
    }

    @Nonnull
    protected Response doSetMergeQueueSettings(@Nonnull RestSetMergeQueueSettingsRequest request, @Nonnull Scope scope) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(scope, "scope");
        this.validateSetRequest(request, scope);
        MergeQueueSettings settings = this.maybeSetWithRestriction(request, scope);
        ProjectSettingsRestrictionState restrictionState = this.getRestrictionState(scope);
        return Response.ok((Object)new RestMergeQueueSettings(settings, restrictionState)).build();
    }

    private ProjectSettingsRestrictionState getRestrictionState(Scope scope) {
        return (ProjectSettingsRestrictionState)scope.accept((ScopeVisitor)new ScopeVisitor<ProjectSettingsRestrictionState>(){

            public ProjectSettingsRestrictionState visit(@Nonnull GlobalScope scope) {
                throw new IllegalArgumentException("Global scope has no restriction state.");
            }

            public ProjectSettingsRestrictionState visit(@Nonnull ProjectScope projectScope) {
                return this.doGet(projectScope.getProject());
            }

            public ProjectSettingsRestrictionState visit(@Nonnull RepositoryScope repositoryScope) {
                return this.doGet(repositoryScope.getProject());
            }

            private ProjectSettingsRestrictionState doGet(Project project) {
                return AbstractMergeQueueSettingsResource.this.projectSettingsRestrictionService.get(project, ProjectSettingsRestrictionKeys.MERGE_QUEUE).map(ProjectSettingsRestriction::getProcessedState).map(ProjectSettingsRestrictionState::fromProcessedState).orElse(ProjectSettingsRestrictionState.NONE);
            }
        });
    }

    private MergeQueueSettings maybeSetWithRestriction(final RestSetMergeQueueSettingsRequest request, final Scope scope) {
        return (MergeQueueSettings)scope.accept((ScopeVisitor)new ScopeVisitor<MergeQueueSettings>(){

            public MergeQueueSettings visit(@Nonnull ProjectScope scope2) {
                return (MergeQueueSettings)AbstractMergeQueueSettingsResource.this.projectSettingsRestrictionService.withRestriction(scope2.getProject(), ProjectSettingsRestrictionKeys.MERGE_QUEUE, request.getRestrictionAction(), this::doSet);
            }

            public MergeQueueSettings visit(@Nonnull RepositoryScope scope2) {
                return this.doSet();
            }

            private MergeQueueSettings doSet() {
                return AbstractMergeQueueSettingsResource.this.mergeQueueSettingsService.set(new SetMergeQueueSettingsRequest.Builder(scope).enabled(request.isEnabled().booleanValue()).mergeTimeout(request.getMergeTimeout()).build());
            }
        });
    }

    private void validateSetRequest(final RestSetMergeQueueSettingsRequest request, Scope scope) {
        if (request.isEnabled() == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.mergequeue.enabled.required", new Object[0]));
        }
        scope.accept((ScopeVisitor)new ScopeVisitor<Object>(){

            public Void visit(@Nonnull ProjectScope scope) {
                if (request.getRestrictionAction() == null) {
                    throw new BadRequestException(AbstractMergeQueueSettingsResource.this.i18nService.getMessage("bitbucket.rest.mergequeue.restriction-action.required", new Object[0]));
                }
                return null;
            }
        });
    }
}

