/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.mergequeue;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.rest.mergequeue.AbstractMergeQueueSettingsResource;
import com.atlassian.stash.internal.rest.mergequeue.RestSetMergeQueueSettingsRequest;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Hidden
@Singleton
@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/settings/merge-queue")
public class RepositoryMergeQueueSettingsResource
extends AbstractMergeQueueSettingsResource {
    @Inject
    public RepositoryMergeQueueSettingsResource(I18nService i18nService, MergeQueueSettingsService mergeQueueSettingsService, ProjectSettingsRestrictionService projectSettingsRestrictionService) {
        super(i18nService, mergeQueueSettingsService, projectSettingsRestrictionService);
    }

    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteMergeQueueSettings(@BeanParam RepositoryResolver repositoryResolver) {
        this.mergeQueueSettingsService.deleteSettingsFor(repositoryResolver.getRepository());
        return Response.noContent().build();
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMergeQueueSettings(@BeanParam RepositoryResolver repositoryResolver) {
        return this.doGetMergeQueueSettings((Scope)Scopes.repository((Repository)repositoryResolver.getRepository()));
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMergeQueueSettings(@BeanParam RepositoryResolver repositoryResolver, RestSetMergeQueueSettingsRequest request) {
        return this.doSetMergeQueueSettings(request, (Scope)Scopes.repository((Repository)repositoryResolver.getRepository()));
    }
}

