/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.mesh;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/config")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class MeshConfigResource {
    private static final String CONTROL_PLANE_PEM = "control-plane.pem";
    private final DmzMeshService meshService;

    @Inject
    public MeshConfigResource(DmzMeshService meshService) {
        this.meshService = meshService;
    }

    @Operation(description="Obtain the control plane PEM.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Get the control plane PEM")
    @ApiResponses(value={@ApiResponse(description="The control plane PEM.", responseCode="200", content={@Content(mediaType="text/plain")}), @ApiResponse(description="The currently authenticated user has insufficient permissions to call this resource.", responseCode="401", content={@Content(schema=@Schema(implementation=RestErrors.class), mediaType="application/json")})})
    @GET
    @Path(value="control-plane.pem")
    @Produces(value={"text/plain"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getControlPlanePublicKey() {
        return ResponseFactory.ok().entity((headers, output) -> {
            String contentDisposition = ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.ATTACHMENT, (String)CONTROL_PLANE_PEM);
            headers.putSingle((Object)"Content-Disposition", (Object)contentDisposition);
            headers.putSingle((Object)"Content-Type", (Object)"text/plain");
            this.meshService.writeControlPlanePublicKey(output);
            output.flush();
        }).cacheControl(CachePolicies.noCache()).build();
    }
}

