/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.mesh;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.rest.mesh.RestMeshConnectivityReport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@SystemAdminOnly
@Consumes(value={"application/json"})
@Path(value="admin/git/mesh/diagnostics")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class MeshDiagnosticsResource {
    private final DmzMeshService meshService;

    @Inject
    public MeshDiagnosticsResource(DmzMeshService meshService) {
        this.meshService = meshService;
    }

    @Operation(description="Generates a connectivity report between the Bitbucket node(s) and the Mesh node(s).\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Generate Mesh connectivity report")
    @ResponseDocs(value={@ResponseDoc(documentation="The connectivity report between the Bitbucket node(s) and Mesh node(s).", representation=RestMeshConnectivityReport.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true)})
    @GET
    @Path(value="/connectivity")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response connectivity() {
        return Response.ok((Object)((Object)new RestMeshConnectivityReport(this.meshService.getConnectivityReports()))).build();
    }
}

