/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.mesh;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshNode;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.MeshNodeConnectionException;
import com.atlassian.bitbucket.mesh.MeshNodeIncompatibleException;
import com.atlassian.bitbucket.mesh.NoSuchMeshNodeException;
import com.atlassian.bitbucket.mesh.RegisterMeshNodeRequest;
import com.atlassian.bitbucket.mesh.UpdateMeshNodeRequest;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ContentDispositionUtils;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;

@SystemAdminOnly
@Consumes(value={"application/json"})
@jakarta.ws.rs.Path(value="admin/git/mesh")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
@WebSudoRequired
public class MeshResource {
    private final DmzMeshService meshService;
    private final Validator validator;

    @Inject
    public MeshResource(DmzMeshService meshService, Validator validator) {
        this.meshService = meshService;
        this.validator = validator;
    }

    @Operation(description="Delete a Mesh node\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Delete Mesh node")
    @DELETE
    @jakarta.ws.rs.Path(value="/nodes/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@PathParam(value="id") long id, @QueryParam(value="force") @DefaultValue(value="false") boolean force) {
        this.meshService.unregister(id, force);
        return ResponseFactory.ok().build();
    }

    @Operation(description="Get all the registered Mesh nodes.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Get all registered Mesh nodes")
    @ResponseDocs(value={@ResponseDoc(documentation="The list of registered Mesh nodes.", representation=RestMeshNode.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true)})
    @GET
    @jakarta.ws.rs.Path(value="/nodes")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllRegisteredMeshNodes() {
        return ResponseFactory.ok(this.meshService.getMembers().stream().filter(meshNode -> !meshNode.isSidecar()).map(RestMeshNode::new).collect(Collectors.toList())).build();
    }

    @Operation(description="Get the registered Mesh node that matches the supplied ID.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Get Mesh node")
    @Parameter(description="The ID of the Mesh node.", in=ParameterIn.PATH, name="id")
    @ResponseDocs(value={@ResponseDoc(documentation="The Mesh node that matches the ID.", representation=RestMeshNode.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The Mesh node does not exist.", restError=true, responseCode=404)})
    @GET
    @jakarta.ws.rs.Path(value="/nodes/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRegisteredMeshNodeById(@PathParam(value="id") long id) {
        return ResponseFactory.ok((Object)new RestMeshNode(this.meshService.getMember(id))).build();
    }

    @Operation(description="Get the support zip for the Mesh node that matches the specified ID.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Get support zip for node")
    @Parameter(description="The ID of the Mesh node.", in=ParameterIn.PATH, name="id")
    @ApiResponses(value={@ApiResponse(description="The support zip for the Mesh node that matches the ID.", responseCode="200", content={@Content(mediaType="application/octet-stream")}), @ApiResponse(description="The currently authenticated user has insufficient permissions to call this resource.", responseCode="401", content={@Content(schema=@Schema(implementation=RestErrors.class), mediaType="application/json")}), @ApiResponse(description="The Mesh node does not exist.", responseCode="404", content={@Content(schema=@Schema(implementation=RestErrors.class), mediaType="application/json")})})
    @GET
    @jakarta.ws.rs.Path(value="/support-zips/{id}")
    @Produces(value={"application/octet-stream"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSupportZip(@PathParam(value="id") long id) throws IOException, NoSuchMeshNodeException {
        Path supportZip = this.meshService.getSupportZip(id);
        String contentDisposition = ContentDispositionUtils.buildHeaderValue((ContentDispositionUtils.DispositionType)ContentDispositionUtils.DispositionType.ATTACHMENT, (String)supportZip.getFileName().toString());
        return Response.ok(so -> Files.copy(supportZip, so)).header("Content-Disposition", (Object)contentDisposition).header("Content-Type", (Object)"application/zip").header("Content-Length", (Object)MoreFiles.size((Path)supportZip)).build();
    }

    @Operation(description="Get the support zips for all the Mesh nodes.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Get support zips for all Mesh nodes")
    @ApiResponses(value={@ApiResponse(description="The support zips for all the Mesh nodes.", responseCode="200", content={@Content(mediaType="application/octet-stream")}), @ApiResponse(description="The currently authenticated user has insufficient permissions to call this resource.", responseCode="401", content={@Content(schema=@Schema(implementation=RestErrors.class), mediaType="application/json")})})
    @GET
    @jakarta.ws.rs.Path(value="/support-zips")
    @Produces(value={"application/octet-stream"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSupportZips() {
        Path supportZip = this.meshService.getSupportZips();
        return Response.ok(so -> Files.copy(supportZip, so)).header("Content-Disposition", (Object)("attachment; filename=\"" + String.valueOf(supportZip.getFileName()) + "\"")).header("Content-Type", (Object)"application/zip").header("Content-Length", (Object)MoreFiles.size((Path)supportZip)).build();
    }

    @Operation(description="Register a new Mesh node.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Register new Mesh node")
    @ResponseDocs(value={@ResponseDoc(documentation="The newly registered Mesh node.", representation=RestMeshNode.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400)})
    @RequestBody(description="The request specifying the new Mesh node.", content={@Content(schema=@Schema(implementation=RestMeshNode.class))})
    @POST
    @jakarta.ws.rs.Path(value="/nodes")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response registerNewMeshNode(RestMeshNode request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[]{Create.class});
        try {
            MeshNode registered = this.meshService.register(new RegisterMeshNodeRequest.Builder().availabilityZone(request.getAvailabilityZone()).name(request.getName()).rpcUrl(request.getRpcUrl()).build());
            return ResponseFactory.ok((Object)new RestMeshNode(registered)).build();
        }
        catch (MeshNodeConnectionException | MeshNodeIncompatibleException e) {
            return MeshResource.toErrorResponse((ServiceException)e);
        }
    }

    @Operation(description="Update a Mesh node.\n\nThe authenticated user must have **SYS_ADMIN** permission.", summary="Update Mesh node")
    @Parameter(description="The ID of the Mesh node to update.", in=ParameterIn.PATH, name="id")
    @ResponseDocs(value={@ResponseDoc(documentation="The updated Mesh node.", representation=RestMeshNode.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400)})
    @RequestBody(description="The request specifying the updated Mesh node.", content={@Content(schema=@Schema(implementation=RestMeshNode.class))})
    @PUT
    @jakarta.ws.rs.Path(value="/nodes/{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateMeshNode(@PathParam(value="id") long id, RestMeshNode request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        UpdateMeshNodeRequest.Builder builder = new UpdateMeshNodeRequest.Builder(id);
        if (request.getName() != null) {
            builder.name(request.getName());
        }
        if (request.getRpcUrl() != null) {
            builder.rpcUrl(request.getRpcUrl());
        }
        if (request.getState() != null) {
            builder.state(request.getState());
        }
        try {
            MeshNode updated = this.meshService.update(builder.build());
            return ResponseFactory.ok((Object)new RestMeshNode(updated)).build();
        }
        catch (MeshNodeConnectionException | MeshNodeIncompatibleException e) {
            return MeshResource.toErrorResponse((ServiceException)e);
        }
    }

    private static Response toErrorResponse(ServiceException e) {
        return ResponseFactory.error((Response.Status)Response.Status.BAD_REQUEST, (String)"rpcUrl", (String)e.getLocalizedMessage()).build();
    }
}

