/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.mesh;

import com.atlassian.bitbucket.dmz.mesh.ConnectivityNode;
import com.atlassian.bitbucket.dmz.mesh.ConnectivityReportNodeType;
import com.atlassian.bitbucket.dmz.mesh.MeshConnectivityReport;
import com.atlassian.bitbucket.dmz.mesh.MeshConnectivitySummary;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;

public class RestMeshConnectivityReport
extends RestMapEntity {
    private static final String CONNECTIVITY_SUMMARIES = "connectivitySummaries";
    private static final String NODE = "node";

    public RestMeshConnectivityReport(List<MeshConnectivityReport> reports) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MeshConnectivityReport report : reports) {
            builder.add((Object)new RestNodeConnectivityReport(report.getNode(), report.getSummaries()));
        }
        this.put(CONNECTIVITY_SUMMARIES, builder.build());
    }

    @Nonnull
    @ArraySchema(schema=@Schema(implementation=RestNodeConnectivityReport.class))
    public List<RestNodeConnectivityReport> getReports() {
        return (List)this.get(CONNECTIVITY_SUMMARIES);
    }

    private class RestNodeConnectivityReport
    extends RestMapEntity {
        private static final String CONNECTIVITY = "connectivity";

        RestNodeConnectivityReport(ConnectivityNode node, List<MeshConnectivitySummary> summaries) {
            this.put(RestMeshConnectivityReport.NODE, (Object)new RestNode(node));
            this.put(CONNECTIVITY, summaries.stream().map(result -> new RestNodeConnectivitySummary((MeshConnectivitySummary)result)).collect(Collectors.toList()));
        }

        @Nonnull
        @Schema(implementation=RestNode.class)
        public RestNode getNode() {
            return (RestNode)((Object)this.get(RestMeshConnectivityReport.NODE));
        }

        @Nonnull
        @ArraySchema(schema=@Schema(implementation=RestNodeConnectivitySummary.class))
        public List<RestNodeConnectivitySummary> getSummaries() {
            return (List)this.get(CONNECTIVITY);
        }
    }

    private class RestNodeConnectivitySummary
    extends RestMapEntity {
        private static final String SUMMARY = "summary";

        RestNodeConnectivitySummary(MeshConnectivitySummary result) {
            this.put(RestMeshConnectivityReport.NODE, (Object)new RestNode(result.getNode()));
            this.put(SUMMARY, (Object)new RestConnectivitySummary(result.getErrorMessage(), result.getRoundTripTime(), result.isReachable()));
        }

        @Nonnull
        @Schema(implementation=RestNode.class)
        public RestNode getNode() {
            return (RestNode)((Object)this.get(RestMeshConnectivityReport.NODE));
        }

        @Nonnull
        @Schema(implementation=RestConnectivitySummary.class)
        public RestConnectivitySummary getSummary() {
            return (RestConnectivitySummary)((Object)this.get(SUMMARY));
        }
    }

    private class RestNode
    extends RestMapEntity {
        private static final String ID = "id";
        private static final String NAME = "name";
        private static final String TYPE = "type";

        RestNode(ConnectivityNode node) {
            this.put(ID, node.getId());
            this.put(NAME, node.getName());
            this.put(TYPE, node.getType());
        }

        @Nonnull
        @Schema(example="1")
        public String getId() {
            return this.getStringProperty(ID);
        }

        @Nonnull
        @Schema(example="My Node")
        public String getName() {
            return this.getStringProperty(NAME);
        }

        @Nonnull
        @Schema(implementation=ConnectivityReportNodeType.class)
        public ConnectivityReportNodeType getType() {
            return (ConnectivityReportNodeType)this.get(TYPE);
        }
    }

    private class RestConnectivitySummary
    extends RestMapEntity {
        private static final String ERROR_MESSAGE = "errorMessage";
        private static final String REACHABLE = "reachable";
        private static final String ROUND_TRIP_TIME = "roundTripTime";

        RestConnectivitySummary(String errorMessage, long roundTripTime, boolean reachable) {
            this.put(REACHABLE, reachable);
            this.put(ROUND_TRIP_TIME, roundTripTime);
            this.putIfNotNull(ERROR_MESSAGE, errorMessage);
        }

        @Nullable
        @Schema(example="Unable to connect to the node.")
        public String getErrorMessage() {
            return this.getStringProperty(ERROR_MESSAGE);
        }

        @Schema(example="TRUE")
        public boolean getReachable() {
            return this.getBoolProperty(REACHABLE);
        }

        @Schema(example="100")
        public long getRoundTripTime() {
            return this.getLongProperty(ROUND_TRIP_TIME);
        }
    }
}

