/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.migration;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.migration.DmzMigrationService;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState;
import com.atlassian.bitbucket.dmz.migration.MigrationRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.rest.v2.job.RestJob;
import com.atlassian.bitbucket.dmz.rest.v2.job.RestJobMessage;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshMigrationRequest;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestExportRequest;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestImportRequest;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestMeshMigrationSummary;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestMigrationRepository;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestRepositoriesExportRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.migration.ExportRequest;
import com.atlassian.bitbucket.migration.ImportRequest;
import com.atlassian.bitbucket.migration.MeshMigrationRequest;
import com.atlassian.bitbucket.migration.MigrationJobMessageSearchRequest;
import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.atlassian.bitbucket.migration.RepositorySelector;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.stash.internal.rest.migration.MigrationExportInfoEvent;
import com.atlassian.stash.internal.rest.migration.MigrationImportInfoEvent;
import com.atlassian.stash.internal.rest.migration.RestScopesExample;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@AdminOnly
@Consumes(value={"application/json"})
@Path(value="migration")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="System Maintenance")
public class MigrationResource {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final DmzMigrationService migrationService;
    private final Validator validator;

    @Inject
    public MigrationResource(EventPublisher eventPublisher, I18nService i18nService, DmzMigrationService migrationService, Validator validator) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.migrationService = migrationService;
        this.validator = validator;
    }

    @Operation(description="Requests the cancellation of an export job.\n\nThe request to cancel a job will be processed successfully if the job is actually still running. If it has already finished (successfully or with errors) or if it has already been canceled before, then an error will be returned.\n\nThere might be a small delay between accepting the request and actually cancelling the job. In most cases, the delay will be close to instantaneously. In the unlikely case of communication issues across a cluster, it can however take a few seconds to cancel a job.\n\nA client should always actively query the job status to confirm that a job has been successfully canceled.\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Cancel export job")
    @Parameter(description="the ID of the job to cancel", in=ParameterIn.PATH, name="jobId")
    @ResponseDocs(value={@ResponseDoc(documentation="The job has successfully been marked for cancellation", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to cancel this job.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified job does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The job was in a state that does not allow cancellation, e.g. it has already finished.", restError=true, responseCode=409)})
    @POST
    @Path(value="exports/{jobId}/cancel")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelExportJob(@PathParam(value="jobId") long jobId) {
        try {
            return this.migrationService.cancelExport(jobId).map(job -> ResponseFactory.noContent()).orElse(ResponseFactory.notFound().entity((Object)this.noSuchExportJob(jobId))).build();
        }
        catch (IllegalStateException e) {
            return ResponseFactory.conflict().entity((Object)this.canNotBeCanceled(jobId)).build();
        }
    }

    @Operation(description="Requests the cancellation of an import job.\n\nThe request to cancel a job will be processed successfully if the job is actually still running. If it has already finished (successfully or with errors) or if it has already been canceled before, then an error will be returned.\n\nNote that import jobs are not canceled as instantaneously as export jobs. Rather, once the request has been accepted, there are a number of checkpoints at which the job will actually apply it and stop. This is to keep the system in a reasonably consistent state:\n\n- After the current fork hierarchy has been imported and verified.\n- Before the next repository is imported.\n- Before the next pull request is imported.\n\nA client should always actively query the job status to confirm that a job has been successfully canceled.\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Cancel import job")
    @Parameter(description="the ID of the job to cancel", in=ParameterIn.PATH, name="jobId")
    @ResponseDocs(value={@ResponseDoc(documentation="The job has successfully been marked for cancellation.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to cancel this job.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified job does not exist.", restError=true, responseCode=404), @ResponseDoc(documentation="The job was in a state that does not allow cancellation, e.g. it has already finished.", restError=true, responseCode=409)})
    @POST
    @Path(value="imports/{jobId}/cancel")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelImportJob(@PathParam(value="jobId") long jobId) {
        try {
            return this.migrationService.cancelImport(jobId).map(job -> ResponseFactory.noContent()).orElse(ResponseFactory.notFound().entity((Object)this.noSuchImportJob(jobId))).build();
        }
        catch (IllegalStateException e) {
            return ResponseFactory.conflict().entity((Object)this.canNotBeCanceled(jobId)).build();
        }
    }

    @Operation(description="Requests the cancellation of a migration job. \n\nThe request to cancel a job will be processed successfully if the job is actually still running. If it has already finished (successfully or with errors) or if it has already been canceled before, then an error will be returned. \n\nThere might be a small delay between accepting the request and actually cancelling the job. In most cases, the delay will be close to instantaneously. In the unlikely case of communication issues across a cluster, it can however take a few seconds to cancel a job.\n\nA client should always actively query the job status to confirm that a job has been successfully canceled.\n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Cancel Mesh migration job")
    @Parameters(value={@Parameter(name="jobId", description="The ID of the job to cancel", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The migration job was successfully marked for cancellation.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified job ID does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The migration job has already been canceled or finished.", responseCode=409, restError=true)})
    @POST
    @Path(value="mesh/{jobId}/cancel")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cancelMeshMigrationJob(@PathParam(value="jobId") long jobId) {
        try {
            return this.migrationService.cancelMeshMigration(jobId).map(job -> ResponseFactory.noContent()).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noSuchMeshMigrationJob(jobId))).build();
        }
        catch (IllegalStateException e) {
            return ResponseFactory.conflict().entity((Object)this.canNotBeCanceled(jobId)).build();
        }
    }

    @Operation(description="Gets the summary, including the queue status and progress, of the currently active Mesh migration job.\n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Get summary for Mesh migration job")
    @ResponseDocs(value={@ResponseDoc(documentation="The summary of the currently active migration job.", representation=RestMeshMigrationSummary.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="No active migration job found.", responseCode=404, restError=true)})
    @GET
    @Path(value="mesh/summary")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getActiveMeshMigrationSummary() {
        return this.migrationService.getMeshMigrationSummary(null).map(RestMeshMigrationSummary::new).map(ResponseFactory::ok).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noActiveMeshMigrationJob())).build();
    }

    @Operation(description="Retrieve a page of Mesh migration job summaries. Jobs are ordered by when they were started, newest first. \n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Get all Mesh migration job summaries")
    @ResponseDocs(value={@ResponseDoc(documentation="The summary of the migration job.", paged=true, representation=RestMeshMigrationSummary.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true)})
    @GET
    @Path(value="mesh/summaries")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllMeshMigrationSummaries(@BeanParam PageRequestResolver pageRequestResolver) {
        Page page = this.migrationService.findAllMeshMigrationSummaries(pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestMeshMigrationSummary::new)).build();
    }

    @Operation(description="Gets the details, including the current status and progress, of the export job identified by the given ID.\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Get export job details")
    @Parameter(description="the ID of the job", in=ParameterIn.PATH, name="jobId")
    @ResponseDocs(value={@ResponseDoc(documentation="The job, including status and progress information.", representation=RestJob.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve information about this job.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified job does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="exports/{jobId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getExportJob(@PathParam(value="jobId") long jobId) {
        return this.migrationService.getExportJob(jobId).map(j -> {
            this.eventPublisher.publish((Object)new MigrationExportInfoEvent(this, (Job)j));
            return j;
        }).map(RestJob::new).map(ResponseFactory::ok).orElse(ResponseFactory.notFound().entity((Object)this.noSuchExportJob(jobId))).build();
    }

    @Operation(description="Gets the messages generated by the job.\n\nWithout any filter, all messages will be returned, but the response can optionally be filtered for the following severities. The severity parameter can be repeated to include multiple severities in one response.\n\n- INFO\n- WARN\n- ERROR\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Get job messages")
    @Parameters(value={@Parameter(description="The ID of the job", in=ParameterIn.PATH, name="jobId"), @Parameter(description="The severity to include in the results", in=ParameterIn.QUERY, name="severity"), @Parameter(description="The subject", in=ParameterIn.QUERY, name="subject")})
    @ResponseDocs(value={@ResponseDoc(documentation="The messages generated by this job.", representation=RestJobMessage.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve information about this job.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified job does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="exports/{jobId}/messages")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getExportJobMessages(@PathParam(value="jobId") long jobId, @QueryParam(value="severity") List<String> severity, @QueryParam(value="subject") String subject, @BeanParam PageRequestResolver pageRequestResolver) {
        try {
            Page messages = this.migrationService.searchExportJobMessages(this.toMigrationJobMessageSearchRequest(jobId, severity, subject), pageRequestResolver.getPageRequest());
            return ResponseFactory.ok((Object)new RestPage(messages, RestJobMessage::new)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.notFound().entity((Object)this.noSuchExportJob(jobId)).build();
        }
    }

    @Operation(description="Gets the details, including the current status and progress, of the import job identified by the given ID.\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Get import job status")
    @Parameter(description="The ID of the job", in=ParameterIn.PATH, name="jobId")
    @ResponseDocs(value={@ResponseDoc(documentation="The job, including status and progress information.", representation=RestJob.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve information about this job.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified job does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="imports/{jobId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getImportJob(@PathParam(value="jobId") long jobId) {
        return this.migrationService.getImportJob(jobId).map(j -> {
            this.eventPublisher.publish((Object)new MigrationImportInfoEvent(this, (Job)j));
            return j;
        }).map(RestJob::new).map(ResponseFactory::ok).orElse(ResponseFactory.notFound().entity((Object)this.noSuchImportJob(jobId))).build();
    }

    @Operation(description="Gets the messages generated by the job.\n\nWithout any filter, all messages will be returned, but the response can optionally be filtered for the following severities. The severity parameter can be repeated to include multiple severities in one response.\n\n- INFO\n- WARN\n- ERROR\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Get import job messages")
    @Parameters(value={@Parameter(description="The ID of the job", in=ParameterIn.PATH, name="jobId"), @Parameter(description="The severity to include in the results", in=ParameterIn.QUERY, name="severity"), @Parameter(description="The subject", in=ParameterIn.QUERY, name="subject")})
    @ResponseDocs(value={@ResponseDoc(documentation="The messages generated by this job.", representation=RestJobMessage.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to retrieve information about this job.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified job does not exist.", restError=true, responseCode=404)})
    @GET
    @Path(value="imports/{jobId}/messages")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getImportJobMessages(@PathParam(value="jobId") long jobId, @QueryParam(value="severity") List<String> severity, @QueryParam(value="subject") String subject, @BeanParam PageRequestResolver pageRequestResolver) {
        try {
            Page messages = this.migrationService.searchImportJobMessages(this.toMigrationJobMessageSearchRequest(jobId, severity, subject), pageRequestResolver.getPageRequest());
            return ResponseFactory.ok((Object)new RestPage(messages, RestJobMessage::new)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.notFound().entity((Object)this.noSuchImportJob(jobId)).build();
        }
    }

    @Operation(description="Gets the details, including the current status and progress, of the job identified by the given ID.\n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Get Mesh migration job details")
    @Parameters(value={@Parameter(name="jobId", description="The ID of the job", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The details of the migration job.", responseCode=200), @ResponseDoc(documentation="The job ID parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified job ID does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="mesh/{jobId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMeshMigrationJob(@PathParam(value="jobId") long jobId) {
        return this.migrationService.getMeshMigrationJob(jobId).map(RestJob::new).map(ResponseFactory::ok).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noSuchMeshMigrationJob(jobId))).build();
    }

    @Operation(description="Gets the messages generated by the job. \n\nWithout any filter, all messages will be returned, but the response can optionally be filtered for the following severities. The severity parameter can be repeated to include multiple severities in one response. \n\n     - INFO\n     - WARN\n     - ERROR\n\n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Get Mesh migration job messages")
    @Parameters(value={@Parameter(name="jobId", description="The ID of the job", in=ParameterIn.PATH), @Parameter(name="severity", description="The severity to include in the results", in=ParameterIn.QUERY), @Parameter(name="subject", description="The subject", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="The details of the migration job.", paged=true, representation=RestJobMessage.class, responseCode=200), @ResponseDoc(documentation="The job ID parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified job ID does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="mesh/{jobId}/messages")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMeshMigrationJobMessages(@PathParam(value="jobId") long jobId, @QueryParam(value="severity") List<String> severity, @QueryParam(value="subject") String subject, @BeanParam PageRequestResolver pageRequestResolver) {
        try {
            Page messages = this.migrationService.searchMeshMigrationJobMessages(this.toMigrationJobMessageSearchRequest(jobId, severity, subject), pageRequestResolver.getPageRequest());
            return ResponseFactory.ok((Object)new RestPage(messages, RestJobMessage::new)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.notFound().entity((Object)this.noSuchMeshMigrationJob(jobId)).build();
        }
    }

    @Operation(description="Gets the summary, including the queue status and progress, of a Mesh migration job. \n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Get Mesh migration job summary")
    @Parameters(value={@Parameter(name="jobId", description="The ID of the job", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The summary of the migration job.", representation=RestMeshMigrationSummary.class, responseCode=200), @ResponseDoc(documentation="The job ID parameter was not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified job ID does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="mesh/{jobId}/summary")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMeshMigrationJobSummary(@PathParam(value="jobId") long jobId) {
        return this.migrationService.getMeshMigrationSummary(Long.valueOf(jobId)).map(RestMeshMigrationSummary::new).map(ResponseFactory::ok).orElseGet(() -> ResponseFactory.notFound().entity((Object)this.noSuchMeshMigrationJob(jobId))).build();
    }

    @Operation(description="Enumerates the projects and repositories that would be exported for a given export request.\n\nAll affected repositories will be enumerated explicitly, and while projects are listed as individual items in responses from this endpoint, their presence does not imply that all their repositories are included.\n\nWhile this endpoint can be used to verify that all selectors in the request apply as intended, it should be noted that a subsequent, actual export might contain a different set of repositories, as they might have been added or deleted in the meantime.\n\nNote that the overall response from this endpoint can become very large when a lot of repositories end up in the selection. This is why the server is streaming the response while it is being generated (as opposed to creating it in memory and then sending it all at once) and it can be consumed in a streaming way, too.\n\nAlso, due to the potential size of the response, projects and repositories are listed with fewer details than in other REST responses.\n\nFor a more detailed description of selectors, see the endpoint documentation for starting an export.\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Preview export")
    @RequestBody(description="the export request", content={@Content(schema=@Schema(implementation=RestExportRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The effectively selected projects and repositories.", representation=RestScopesExample.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to generate a preview.", restError=true, responseCode=401)})
    @POST
    @Path(value="exports/preview")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response previewExport(RestExportRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        final Stream exportScopes = this.migrationService.previewExport(this.toExportRequest(request));
        return ResponseFactory.ok((Object)new JsonStreamingOutput(this){

            public void write(StatefulJsonWriter writer) throws IOException {
                writer.beginObject();
                writer.name("scopes");
                writer.beginArray();
                for (Scope scope : exportScopes::iterator) {
                    writer.value(scope.accept((ScopeVisitor)new ScopeVisitor<Object>(this){

                        public RestProject visit(@Nonnull ProjectScope scope) {
                            return RestProject.simple((Project)scope.getProject());
                        }

                        public RestRepository visit(@Nonnull RepositoryScope scope) {
                            return RestRepository.simple((Repository)scope.getRepository());
                        }
                    }));
                }
                writer.endArray();
                writer.endObject();
            }
        }).build();
    }

    @Operation(description="Enumerates the projects and repositories that would be migrated for a given request.\n\nAll affected repositories will be enumerated explicitly, and while projects are listed as individual items in responses from this endpoint, their presence does not imply that all their repositories are included.\n\nWhile this endpoint can be used to verify that all selectors in the request apply as intended, it should be noted that a subsequent, actual export might contain a different set of repositories, as they might have been added or deleted in the meantime.\n\nNote that the overall response from this endpoint can become very large when a lot of repositories end up in the selection. This is why the server is streaming the response while it is being generated (as opposed to creating it in memory and then sending it all at once) and it can be consumed in a streaming way, too.\n\nAlso, due to the potential size of the response, projects and repositories are listed with fewer details than in other REST responses.\n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Preview Mesh migration")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestMeshMigrationRequest.class))}, description="The export request")
    @ResponseDocs(value={@ResponseDoc(documentation="Enumeration of projects and repositories that would be migrated for a given request.", representation=ExamplePreviewMigration.class, responseCode=200), @ResponseDoc(documentation="The request was invalid or missing.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true)})
    @POST
    @Path(value="mesh/preview")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response previewMeshMigration(RestMeshMigrationRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        final Stream repositories = this.migrationService.previewMeshMigration(MigrationResource.toMigrationRequest(request));
        return ResponseFactory.ok((Object)new JsonStreamingOutput(this){

            public void write(StatefulJsonWriter writer) throws IOException {
                writer.beginObject();
                writer.name("repositories");
                writer.beginArray();
                for (Repository repository : repositories::iterator) {
                    writer.value((Object)RestRepository.simple((Repository)repository));
                }
                writer.endArray();
                writer.endObject();
            }
        }).build();
    }

    @Operation(description="Searches for repositories in the system matching the specified criteria and enriches their MeshMigrationQueueState migration state if a migration is currently in progress. \n\nThe currently active migration can optionally be specified by passing a migrationId, if known. If this isn't passed, an attempt is made to locate the active migration and its ID is used. \n\nIf a migration is currently active, only repositories that are a part of the migration are filtered and returned. Otherwise, all repositories in the systems are filtered and returned. \n\nFiltering by state is ignored when no migration is currently in progress. In such a case, results are not enriched with their MeshMigrationQueueState migration state. \n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Find repositories by Mesh migration state")
    @Parameters(value={@Parameter(name="migrationId", description="(optional) The currently active migration job. If not passed, this is looked up internally.", in=ParameterIn.QUERY), @Parameter(name="name", description="(optional) The repository name", in=ParameterIn.QUERY), @Parameter(name="projectKey", description="(optional) The project key. Can be specified more than once to filter by more than one project.", in=ParameterIn.QUERY), @Parameter(name="remote", description="(optional) Whether the repository has been fully migrated to Mesh. If not present, all repositories are considered regardless of where they're located.", in=ParameterIn.QUERY), @Parameter(name="state", description="(optional) If a migration is active, the MeshMigrationQueueState state to filter results by. Can be specified more than once to filter by more than one state.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of repositories matching the specified criteria.", paged=true, representation=RestMigrationRepository.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="No migration job with the given ID exists.", responseCode=404, restError=true)})
    @GET
    @Path(value="mesh/repos")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchMeshMigrationRepos(@QueryParam(value="migrationId") Long migrationId, @QueryParam(value="name") String repositoryName, @QueryParam(value="projectKey") List<String> projectKeys, @QueryParam(value="remote") Boolean remote, @QueryParam(value="state") List<String> state, @BeanParam PageRequestResolver pageRequestResolver) {
        PageRequest pageRequest = pageRequestResolver.getPageRequest();
        MigrationRepositorySearchRequest searchRequest = new MigrationRepositorySearchRequest.Builder().jobId(migrationId).projectKeys(projectKeys).remote(remote).repositoryName(repositoryName).states(MigrationResource.getStates(state)).build();
        try {
            Page page = this.migrationService.searchMeshMigrationRepositories(searchRequest, pageRequest);
            return ResponseFactory.ok((Object)new RestPage(page, RestMigrationRepository.REST_TRANSFORM)).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.notFound().entity((Object)this.noSuchMeshMigrationJob(migrationId)).build();
        }
    }

    @Operation(description="Starts a background job that exports the selected repositories.\n\nOnly 2 concurrent exports are supported _per cluster node_. If a request ends up on a node that is already running that many export jobs, the request will be rejected and an error returned.\n\nThe response includes a description of the job that has been started, and its ID can be used to query these details again, including the current progress, warnings and errors that occurred while processing the job, and to interrupt and cancel the execution of this job.\n\nThe request to start an export is similar to the one for previewing an export. Additionally, it accepts an optional parameter, `exportLocation`, which can be used to specify a _relative_ path within `data/migration/export` in the shared home directory. No locations outside of that directory will be accepted for exports.\n\nThere are essentially three ways to select repositories for export. Regardless of which you use, a few general rules apply:\n\n- You can supply a list of selectors. The selection will be additive.\n- Repositories that are selected more than once due to overlapping selectors will be de-duplicated and effectively exported only once.\n- For every selected repository, its full fork hierarchy will be considered selected, even if parts of that hierarchy would otherwise not be matched by the provided selectors. For example, when you explicitly select a single repository only, but that repository is a fork, then its origin will be exported (and eventually imported), too.\n\nNow, a single repository can be selected like this:\n\n```\n\n\n\n{\n      \"projectKey\": \"PRJ\",\n      \"slug\": \"my-repo\"\n}\n\n```\n\nSecond, all repositories in a specific project can be selected like this:\n\n```\n\n\n\n{\n      \"projectKey\": \"PRJ\",\n      \"slug\": *\"\n}\n\n```\n\nAnd third, all projects and repositories in the system would be selected like this:\n\n```\n\n\n\n{\n      \"projectKey\": \"*\",\n      \"slug\": *\"\n}\n\n```\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Start export job")
    @RequestBody(description="The request", content={@Content(schema=@Schema(implementation=RestExportRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Details about the export job.", representation=RestJob.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to start anexport", restError=true, responseCode=401), @ResponseDoc(documentation="The export could not be started because the limit of concurrent migration jobs has been reached.", restError=true, responseCode=503)})
    @POST
    @Path(value="exports")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startExport(RestExportRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        Job exportJob = this.migrationService.startExport(this.toExportRequest(request));
        return ResponseFactory.ok((Object)new RestJob(exportJob)).build();
    }

    @Operation(description="Starts a background job that imports the specified archive.\n\nOnly 1 import at a time is supported _per cluster_. If another request is made while an import is already running, the request will be rejected and an error returned.\n\nThe path in the request must point to a valid archive file. The file must be located within the `data/migration/import` directory in the shared home directory.\n\nThe authenticated user must have **ADMIN** permission or higher to call this resource.", summary="Start import job")
    @RequestBody(description="The request", content={@Content(schema=@Schema(implementation=RestImportRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Details about the export job.", representation=RestJob.class, responseCode=200), @ResponseDoc(documentation="The request was malformed.", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to start an import.", restError=true, responseCode=401), @ResponseDoc(documentation="The import could not be started because the limit of concurrent migration jobs has been reached.", restError=true, responseCode=503)})
    @POST
    @Path(value="imports")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startImport(RestImportRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        Job exportJob = this.migrationService.startImport(this.toImportRequest(request));
        return ResponseFactory.ok((Object)new RestJob(exportJob)).build();
    }

    @Operation(description="Starts a background job that migrates selected projects/repositories to Mesh. \n\nOnly 1 job is supported _per cluster_.\n\nThe response includes a description of the job that has been started, and its ID can be used to query these details again, including the current progress, and to interrupt and cancel the execution of this job. \n\nThe request to start a migration is similar to the one for previewing a migration. \n\nThere are essentially three ways to select repositories for migration. Regardless of which you use, a few general rules apply: \n\n    - You can supply a list of repository IDs and project IDs. The selection will be additive. All repositories     in the system are migrated if both lists are empty.     - Repositories that are selected more than once due to overlapping IDs will be de-duplicated and     effectively migrated only once.     - For every selected repository, its full fork hierarchy will be considered selected, even if parts of that     hierarchy would otherwise not be matched by the provided IDs. For example, when you explicitly     select a single repository only, but that repository is a fork, then its origin will be migrated too. \n\nNow, a single repository can be selected like this: \n\n```\n\n     {\n     \"repositoryIds\": [1]\n     }\n```\n\nMultiple repositories can be selected like this:\n\n\n\n```\n\n     {\n     \"repositoryIds\": [1, 2]\n     }\n```\n\nSecond, all repositories in a specific project can be selected like this:\n\n\n\n```\n\n     {\n     \"projectIds\": [1]\n     }\n```\n\nAnd third, all projects and repositories in the system would be selected like this:\n\n\n\n```\n\n     {\n     \"projectIds\": [],\n     \"repositoryIds\": []\n     }\n```\n\nThe authenticated user must have **SYS_ADMIN** permission to call this resource.", summary="Start Mesh migration job")
    @ResponseDocs(value={@ResponseDoc(documentation="The started job", representation=RestJob.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", responseCode=401, restError=true), @ResponseDoc(documentation="The migration request failed one/more validation checks.", responseCode=400, restError=true), @ResponseDoc(documentation="A migration job is already in progress", responseCode=503, restError=true)})
    @POST
    @Path(value="mesh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startMeshMigration(RestMeshMigrationRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        Job job = this.migrationService.startMeshMigration(MigrationResource.toMigrationRequest(request));
        return ResponseFactory.ok((Object)new RestJob(job)).build();
    }

    private static MeshMigrationRequest toMigrationRequest(RestMeshMigrationRequest request) {
        return new MeshMigrationRequest.Builder().all(request.isAll()).projectIds((Iterable)request.getProjectIds()).repositoryIds((Iterable)request.getRepositoryIds()).build();
    }

    private RestErrors canNotBeCanceled(long jobId) {
        return new RestErrors.Builder().add(new RestErrorMessage("jobId", this.i18nService.getMessage("bitbucket.rest.migration.cancel.illegal.state", new Object[]{jobId}))).build();
    }

    private static Set<MeshMigrationQueueState> getStates(List<String> states) {
        return states == null ? ImmutableSet.of() : states.stream().map(MeshMigrationQueueState::valueOf).collect(Collectors.toSet());
    }

    private RestErrors noActiveMeshMigrationJob() {
        return new RestErrors.Builder().add(new RestErrorMessage(this.i18nService.getMessage("bitbucket.rest.migration.noactivejob.mesh", new Object[0]))).build();
    }

    private RestErrors noSuchExportJob(long jobId) {
        return new RestErrors.Builder().add(new RestErrorMessage("jobId", this.i18nService.getMessage("bitbucket.rest.migration.nosuchjob.export", new Object[]{jobId}))).build();
    }

    private RestErrors noSuchImportJob(long jobId) {
        return new RestErrors.Builder().add(new RestErrorMessage("jobId", this.i18nService.getMessage("bitbucket.rest.migration.nosuchjob.import", new Object[]{jobId}))).build();
    }

    private RestErrors noSuchMeshMigrationJob(long jobId) {
        return new RestErrors.Builder().add(new RestErrorMessage("jobId", this.i18nService.getMessage("bitbucket.rest.migration.nosuchjob.mesh", new Object[]{jobId}))).build();
    }

    private ExportRequest toExportRequest(RestExportRequest request) {
        RestRepositoriesExportRequest repositoryRequest = request.getRepositoriesRequest();
        Set selectors = repositoryRequest.getIncludes().stream().map(selector -> RepositorySelector.of((String)selector.getProjectKey(), (String)selector.getSlug())).collect(Collectors.toSet());
        return new ExportRequest.Builder().exportLocation(request.getExportLocation()).repositoriesRequest(new RepositoriesExportRequest.Builder().includes(selectors).build()).build();
    }

    private ImportRequest toImportRequest(RestImportRequest request) {
        return new ImportRequest.Builder().archivePath(request.getArchivePath()).build();
    }

    private MigrationJobMessageSearchRequest toMigrationJobMessageSearchRequest(long jobId, List<String> severities, String subject) {
        return new MigrationJobMessageSearchRequest.Builder(jobId).severities(this.toSeverities(severities)).subject(subject).build();
    }

    private Set<JobMessageSeverity> toSeverities(List<String> severities) {
        try {
            return (Set)severities.stream().map(JobMessageSeverity::valueOf).collect(MoreCollectors.toImmutableSet());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.migration.jobseverities.invalid", new Object[]{Joiner.on((char)',').join((Object[])JobMessageSeverity.values())}));
        }
    }

    private static class ExamplePreviewMigration {
        private ExamplePreviewMigration() {
        }

        public RestRepository[] getRepositories() {
            throw new RuntimeException("This method should never be invoked");
        }
    }
}

