/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.project;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.dmz.rest.v2.util.RestPermissionUtils;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectUpdateRequest;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.util.CachePolicies;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.rest.avatar.AvatarMultipartConfig;
import com.atlassian.stash.internal.rest.avatar.FilePartAvatarSupplier;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.net.URI;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Project")
public class ProjectResource {
    private static final String AVATAR_PATH = "{projectKey}/avatar.png";
    private final I18nService i18nService;
    private final ProjectService projectService;

    @Inject
    public ProjectResource(ProjectService projectService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
    }

    @Operation(description="Create a new project. \n\nTo include a custom avatar for the project, the project definition should contain an additional attribute with the key <code>avatar</code> and the value a data URI containing Base64-encoded image data. The URI should be in the following format: <pre>    data:(content type, e.g. image/png);base64,(data) </pre>If the data is not Base64-encoded, or if a character set is defined in the URI, or the URI is otherwise invalid, <em>project creation will fail</em>. \n\nThe authenticated user must have <strong>PROJECT_CREATE</strong> permission to call this resource.", summary="Create a new project")
    @RequestBody(content={@Content(schema=@Schema(implementation=RestProject.class))}, description="The project.")
    @ResponseDocs(value={@ResponseDoc(documentation="The newly created project.", representation=RestProject.class, responseCode=201), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the project.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a project.", responseCode=401, restError=true), @ResponseDoc(documentation="The project key or name is already in use.", responseCode=409, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createProject(@Context UriInfo uriInfo, RestProject projectParam) {
        String projectKey = projectParam.getKey();
        if (projectKey == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.project.noprojectkey", new Object[0]);
            throw new BadRequestException(message);
        }
        String name = projectParam.getName();
        if (name == null) {
            name = projectKey;
        }
        Project project = this.projectService.create(((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)new ProjectCreateRequest.Builder().key(projectKey)).name(name)).description(projectParam.getDescription())).avatarUri(projectParam.getAvatar()).publiclyAccessible(projectParam.isPublic())).build());
        URI projectURI = uriInfo.getRequestUriBuilder().path(project.getKey()).build(new Object[0]);
        return ResponseFactory.created((URI)projectURI).entity(RestProject.REST_TRANSFORM.apply(project)).build();
    }

    @Operation(description="Delete the project matching the supplied <strong>projectKey</strong>. \n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project to call this resource.", summary="Delete project")
    @Parameters(value={@Parameter(description="The project key.", in=ParameterIn.PATH, name="projectKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The project matching the supplied <strong>projectKey</strong> was deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="The project can not be deleted as it contains repositories.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="{projectKey}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteProject(@BeanParam ProjectResolver projectResolver) {
        if (!this.projectService.delete(projectResolver.getProject())) {
            throw new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchproject", new Object[]{projectResolver.getProject().getKey()}));
        }
        return ResponseFactory.noContent().build();
    }

    @Operation(description="Retrieve the project matching the supplied <strong>projectKey</strong>. \n\nThe authenticated user must have <strong>PROJECT_VIEW</strong> permission for the specified project to call this resource.", summary="Get a project")
    @Parameters(value={@Parameter(description="The project key.", in=ParameterIn.PATH, name="projectKey")})
    @ResponseDocs(value={@ResponseDoc(documentation="The project matching the supplied <strong>projectKey</strong>.", representation=RestProject.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{projectKey}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getProject(@BeanParam ProjectResolver projectResolver) {
        return ResponseFactory.ok(RestProject.REST_TRANSFORM.apply(projectResolver.getProject())).build();
    }

    @Operation(description="Retrieve the avatar for the project matching the supplied <strong>projectKey</strong>. \n\nThe authenticated user must have <strong>PROJECT_VIEW</strong> permission for the specified project to call this resource.", summary="Get avatar for project")
    @Parameters(value={@Parameter(description="The project key.", in=ParameterIn.PATH, name="projectKey"), @Parameter(description="The desired size of the image. The server will return an image as close as possible to the specified size.", in=ParameterIn.QUERY, name="s")})
    @ResponseDocs(value={@ResponseDoc(documentation="The avatar of the project matching the supplied <strong>projectKey</strong>.", responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="{projectKey}/avatar.png")
    @Produces(value={"image/png"})
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getProjectAvatar(@Context ContainerRequestContext request, @BeanParam ProjectResolver projectResolver, @QueryParam(value="s") @DefaultValue(value="0") int size) {
        return AvatarRequestHelper.processAvatarResponse((ContainerRequestContext)request, (CacheControl)CachePolicies.noCache(), (CacheableAvatarSupplier)this.projectService.getAvatar(projectResolver.getProject().getId(), size));
    }

    @Operation(description="Retrieve a page of projects. \n\nOnly projects for which the authenticated user has the <strong>PROJECT_VIEW</strong> permission will be returned.", summary="Get projects")
    @Parameters(value={@Parameter(description="Name to filter by.", in=ParameterIn.QUERY, name="name"), @Parameter(description="Permission to filter by", in=ParameterIn.QUERY, name="permission")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of projects.", paged=true, representation=RestProject.class, responseCode=200), @ResponseDoc(documentation="The permission level is unknown or not related to projects.", responseCode=400, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getProjects(@QueryParam(value="name") String name, @QueryParam(value="permission") String permission, @BeanParam PageRequestResolver pageRequestResolver) {
        ProjectSearchRequest.Builder builder = new ProjectSearchRequest.Builder().name(name).permission(RestPermissionUtils.parsePermission((I18nService)this.i18nService, (String)permission, Project.class));
        Page page = this.projectService.search(builder.build(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(page, RestProject.REST_TRANSFORM)).build();
    }

    @Operation(description="Update the project matching the <strong>projectKey</strong> supplied in the resource path. \n\nTo include a custom avatar for the updated project, the project definition should contain an additional attribute with the key <code>avatar</code> and the value a data URI containing Base64-encoded image data. The URI should be in the following format: \n```    data:(content type, e.g. image/png);base64,(data)```\n\nIf the data is not Base64-encoded, or if a character set is defined in the URI, or the URI is otherwise invalid, <em>project creation will fail</em>. \n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project to call this resource.", summary="Update project")
    @Parameters(value={@Parameter(description="The project key.", in=ParameterIn.PATH, name="projectKey")})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestProject.class))}, description="Project parameters to update.")
    @ResponseDocs(value={@ResponseDoc(documentation="The updated project. The project's key <strong>was not</strong> updated.", representation=RestProject.class, responseCode=200), @ResponseDoc(documentation="The updated project. The project's key <strong>was</strong> updated.", representation=RestProject.class, responseCode=201), @ResponseDoc(documentation="The project was not updated due to a validation error.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="{projectKey}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateProject(@BeanParam ProjectResolver projectResolver, RestProject projectParam, @Context UriInfo uriInfo) {
        Project project = projectResolver.getProject();
        ProjectUpdateRequest.Builder builder = (ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)new ProjectUpdateRequest.Builder(project).key((String)MoreObjects.firstNonNull((Object)projectParam.getKey(), (Object)project.getKey()))).name((String)MoreObjects.firstNonNull((Object)projectParam.getName(), (Object)project.getName()))).description(projectParam.getDescription() != null ? projectParam.getDescription() : project.getDescription());
        if (projectParam.hasPublic()) {
            builder.publiclyAccessible(projectParam.isPublic());
        }
        Project updatedProject = this.projectService.update(builder.build());
        if (projectParam.hasAvatar()) {
            this.projectService.updateAvatar(project.getId(), projectParam.getAvatar());
        }
        if (updatedProject.getKey().equals(project.getKey())) {
            return ResponseFactory.ok(RestProject.REST_TRANSFORM.apply(updatedProject)).build();
        }
        String requestPath = uriInfo.getRequestUri().getPath();
        int index = requestPath.toLowerCase().lastIndexOf(project.getKey().toLowerCase());
        String newPath = requestPath.substring(0, index) + updatedProject.getKey();
        return ResponseFactory.created((URI)uriInfo.getRequestUriBuilder().replacePath(newPath).build(new Object[0])).entity(RestProject.REST_TRANSFORM.apply(updatedProject)).build();
    }

    @Operation(description="Update the avatar for the project matching the supplied <strong>projectKey</strong>. \n\nThis resource accepts POST multipart form data, containing a single image in a form-field named 'avatar'. \n\nThere are configurable server limits on both the dimensions (1024x1024 pixels by default) and uploaded file size (1MB by default). Several different image formats are supported, but <strong>PNG</strong> and <strong>JPEG</strong> are preferred due to the file size limit. \n\nThis resource has Cross-Site Request Forgery (XSRF) protection. To allow the request to pass the XSRF check the caller needs to send an <code>X-Atlassian-Token</code> HTTP header with the value <code>no-check</code>. \n\nAn example <a href=\"http://curl.haxx.se/\">curl</a> request to upload an image name 'avatar.png' would be: ```curl -X POST -u username:password -H \"X-Atlassian-Token: no-check\" http://example.com/rest/api/1.0/projects/STASH/avatar.png -F avatar=@avatar.png ```\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission for the specified project to call this resource.", summary="Update project avatar")
    @Parameters(value={@Parameter(description="The project key.", in=ParameterIn.PATH, name="projectKey")})
    @RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExampleAvatarMultipartFormData.class))}, description="The mutlipart form data containing the file.")
    @ResponseDocs(value={@ResponseDoc(documentation="The avatar was uploaded successfully.", responseCode=201), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to update the project.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified project does not exist.", responseCode=404, restError=true)})
    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=AvatarMultipartConfig.class)
    @Path(value="{projectKey}/avatar.png")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response uploadAvatar(@BeanParam ProjectResolver projectResolver, @Context UriInfo uriInfo, @MultipartFormParam(value="avatar") FilePart file) {
        this.projectService.updateAvatar(projectResolver.getProject().getId(), (AvatarSupplier)new FilePartAvatarSupplier(file));
        return Response.created((URI)uriInfo.getRequestUri()).build();
    }

    private static class ExampleAvatarMultipartFormData {
        private ExampleAvatarMultipartFormData() {
        }

        @Schema(description="The avatar file to upload.")
        public File getAvatar() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

